/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Armadillo.class})
public class ArmadilloMixin {
    @Unique
    private final Armadillo subtleEffects$me = (Armadillo)this;

    @Inject(method={"brushOffScute"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/armadillo/Armadillo;gameEvent(Lnet/minecraft/core/Holder;)V")})
    private void addBrushEffects(CallbackInfoReturnable<Boolean> cir) {
        Level level = this.subtleEffects$me.level();
        if (level.isClientSide() && ModConfigs.ITEMS.armadilloBrushParticles) {
            RandomSource random = this.subtleEffects$me.getRandom();
            for (int i = 0; i < 10; ++i) {
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.addParticle((ParticleOptions)ModParticles.ARMADILLO.get(), this.subtleEffects$me.getX() + MathUtil.nextDouble(random, 0.3) * (double)xSign, this.subtleEffects$me.getRandomY() + 0.2, this.subtleEffects$me.getZ() + MathUtil.nextDouble(random, 0.3) * (double)zSign, MathUtil.nextDouble(random, 0.1) * (double)xSign, MathUtil.nextDouble(random, 0.2), MathUtil.nextDouble(random, 0.1) * (double)zSign);
            }
        }
    }
}

