/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AxeItem.class})
public class AxeItemMixin {
    @WrapOperation(method={"evaluateNewBlockState"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V")})
    private void evaluateNewBlockState(Level level, Entity entity, BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch, Operation<Void> original, @Local(argsOnly=true) BlockState state) {
        if (level.isClientSide() && sound.equals((Object)SoundEvents.AXE_STRIP) && ModConfigs.ITEMS.axeStripParticles) {
            level.addDestroyBlockEffect(pos, state);
        }
        original.call(new Object[]{level, entity, pos, sound, source, Float.valueOf(volume), Float.valueOf(pitch)});
    }

    @Inject(method={"spawnSoundAndParticle"}, at={@At(value="HEAD")})
    private static void spawnSoundAndParticle(Level level, BlockPos pos, Player player, BlockState state, SoundEvent sound, int event, CallbackInfo ci) {
        if (level.isClientSide()) {
            if (sound.equals((Object)SoundEvents.AXE_SCRAPE)) {
                if (ModConfigs.ITEMS.axeScrapeParticlesDisplayType != ReplacedParticlesDisplayType.VANILLA) {
                    AxeItemMixin.subtleEffects$spawnCopperParticles(level, pos, state, state);
                }
            } else if (sound.equals((Object)SoundEvents.AXE_WAX_OFF) && ModConfigs.ITEMS.axeWaxOffParticlesDisplayType != ReplacedParticlesDisplayType.VANILLA) {
                AxeItemMixin.subtleEffects$spawnCopperParticles(level, pos, state, Blocks.HONEY_BLOCK.defaultBlockState());
            }
        }
    }

    @Unique
    private static void subtleEffects$spawnCopperParticles(Level level, BlockPos pos, BlockState state, BlockState particleState) {
        ParticleSpawnUtil.spawnParticlesAroundShape((ParticleOptions)new BlockParticleOption(ModParticles.BLOCK_NO_MOMENTUM.get(), particleState), level, pos, state, 10, () -> Vec3.ZERO, 0.0625f);
    }
}

