/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.common.block;

import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePayload;
import einstein.subtle_effects.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BeehiveBlockEntity.class})
public class BeehiveBlockEntityMixin {
    @Unique
    private int subtleEffects$breatheTimer = 0;
    @Unique
    private int subtleEffects$snoreTimer = 0;
    @Unique
    private int subtleEffects$ZCount = 0;

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void serverTick(Level level, BlockPos pos, BlockState state, BeehiveBlockEntity blockEntity, CallbackInfo ci) {
        BeehiveBlockEntityMixin me = (BeehiveBlockEntityMixin)blockEntity;
        if (!blockEntity.isEmpty() && level.isDarkOutside()) {
            if (me.subtleEffects$breatheTimer < 60) {
                ++me.subtleEffects$breatheTimer;
                return;
            }
            if (me.subtleEffects$snoreTimer >= 10) {
                me.subtleEffects$snoreTimer = 0;
                ++me.subtleEffects$ZCount;
                Direction direction = (Direction)state.getValue((Property)BeehiveBlock.FACING);
                Services.NETWORK.sendToClientsTracking((ServerLevel)level, pos, new ClientBoundSpawnSnoreParticlePayload((double)pos.getX() + 0.5 + 0.6 * (double)direction.getStepX(), (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + 0.6 * (double)direction.getStepZ()));
                if (me.subtleEffects$ZCount >= 3) {
                    me.subtleEffects$ZCount = 0;
                    me.subtleEffects$breatheTimer = 0;
                }
            }
            if (me.subtleEffects$snoreTimer < 10) {
                ++me.subtleEffects$snoreTimer;
            }
        } else {
            me.subtleEffects$breatheTimer = 0;
            me.subtleEffects$snoreTimer = 0;
            me.subtleEffects$ZCount = 0;
        }
    }
}

