/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundAnimalFedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundCopperGolemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDispenseBucketPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDrankPotionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityLandInFluidPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundExplosionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockTickPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundMooshroomShearedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSheepShearPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundStonecutterUsedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundVillagerWorkPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPayload;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandlers {
    private static final List<Block> MASON_STONECUTTER_USE_BLOCKS = List.of(Blocks.STONE, Blocks.CHISELED_STONE_BRICKS, Blocks.QUARTZ_BLOCK, Blocks.ANDESITE, Blocks.DIORITE, Blocks.GRANITE);
    private static final List<DyeColor> COMMON_SHEPHERD_WOOL_COLORS = List.of(DyeColor.WHITE, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN);

    public static void handle(ClientLevel level, ClientBoundEntityFellPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, payload.y(), payload.distance(), payload.fallDamage(), ClientPacketHandlers.getEntityFellConfig(payload));
        }
    }

    public static void handle(ClientLevel level, ClientBoundEntitySpawnSprintingDustCloudsPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int ySpeedModifier = 5;
            if (livingEntity instanceof Ravager) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (Level)level, livingEntity.getRandom(), ySpeedModifier);
        }
    }

    public static void handle(ClientLevel level, ClientBoundSpawnSnoreParticlePayload payload) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.addParticle((ParticleOptions)ModParticles.SNORING.get(), payload.x(), payload.y(), payload.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(ClientLevel level, ClientBoundBlockDestroyEffectsPayload payload) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(payload)) {
            BlockPos pos = payload.pos();
            BlockState state = Block.stateById((int)payload.stateId());
            SoundType soundType = state.getSoundType();
            level.addDestroyBlockEffect(pos, state);
            level.playLocalSound(pos, soundType.getBreakSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f, false);
        }
    }

    public static void handle(ClientLevel level, ClientBoundXPBottleEffectsPayload payload) {
        int i;
        BlockPos pos = payload.pos();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)pos);
        RandomSource random = level.getRandom();
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.levelEvent(2002, pos, -13083194);
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ITEMS.projectiles.xpBottleParticlesDensity.get(); ++i) {
                double d = random.nextDouble() * 4.0;
                double d1 = random.nextDouble() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.addParticle((ParticleOptions)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.x + xPower * 0.1, vec3.y + 0.3, vec3.z + zPower * 0.1, xPower, 0.01 + random.nextDouble() * 0.5, zPower);
            }
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.SPLASH_POTION)), vec3.x, vec3.y, vec3.z, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
            }
            level.playLocalSound(pos, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(ClientLevel level, ClientBoundFallingBlockLandPayload payload) {
        BlockPos pos = payload.pos();
        BlockState state = Block.stateById((int)payload.stateId());
        Block block = state.getBlock();
        if (ModConfigs.BLOCKS.fallingBlocks.onLandSound && !(block instanceof AnvilBlock)) {
            SoundType soundType = state.getSoundType();
            Util.playClientSound(pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.onLandDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            boolean isInWater = payload.isInWater() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            RandomSource random = level.getRandom();
            SimpleParticleType options = isInWater ? ParticleTypes.BUBBLE : ClientPacketHandlers.getParticleForFallingBlock(level, pos, state);
            for (int i = 0; i < 25; ++i) {
                boolean bool = random.nextBoolean();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.addParticle((ParticleOptions)options, (double)pos.getX() + 0.5 + (bool ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.getY() + MathUtil.nextDouble(random, 0.3), (double)pos.getZ() + 0.5 + (!bool ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)xSign : 0.0, 0.3, !bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)zSign : 0.0);
            }
        }
    }

    public static void handle(ClientLevel level, ClientBoundFallingBlockTickPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof FallingBlockEntity) {
            entity.fallDistance = payload.fallDistance();
        }
    }

    public static void handle(ClientLevel level, ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles && (!payload.wasFarmer() || ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles)) {
            RandomSource random = level.getRandom();
            ParticleSpawnUtil.spawnCompostParticles((Level)level, payload.pos(), (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    public static void handle(ClientLevel level, ClientBoundStonecutterUsedPayload payload) {
        BlockPos pos = payload.pos();
        ParticleSpawnUtil.spawnStonecutterParticles((Level)level, payload.stack(), pos, level.getBlockState(pos));
    }

    public static void handle(ClientLevel level, ClientBoundVillagerWorkPayload payload) {
        block13: {
            BlockState state;
            BlockPos pos;
            RandomSource random;
            int professionLevel;
            Holder profession;
            block16: {
                block15: {
                    block14: {
                        if (!ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles) {
                            return;
                        }
                        Entity entity = level.getEntity(payload.villagerId());
                        if (!(entity instanceof Villager)) break block13;
                        Villager villager = (Villager)entity;
                        VillagerData villagerData = villager.getVillagerData();
                        profession = villagerData.profession();
                        professionLevel = villagerData.level();
                        random = level.getRandom();
                        pos = payload.pos();
                        state = level.getBlockState(pos);
                        if (!profession.is(VillagerProfession.LEATHERWORKER)) break block14;
                        if (!ModConfigs.BLOCKS.cauldronUseParticles) {
                            return;
                        }
                        double fluidHeight = Util.getCauldronFillHeight(state);
                        ParticleOptions particle = Util.getCauldronParticle(state);
                        if (!(fluidHeight > 0.0) || particle == null) break block13;
                        for (int i = 0; i < 16; ++i) {
                            level.addParticle(particle, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + fluidHeight, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
                        }
                        break block13;
                    }
                    if (!profession.is(VillagerProfession.WEAPONSMITH)) break block15;
                    ParticleSpawnUtil.spawnGrindstoneUsedParticles((Level)level, pos, state, random);
                    break block13;
                }
                if (!profession.is(VillagerProfession.TOOLSMITH)) break block16;
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break block13;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (Level)level);
                break block13;
            }
            if (profession.is(VillagerProfession.MASON)) {
                ParticleSpawnUtil.spawnStonecutterParticles((Level)level, new ItemStack((ItemLike)MASON_STONECUTTER_USE_BLOCKS.get(random.nextInt(MASON_STONECUTTER_USE_BLOCKS.size()))), pos, state);
            } else if (profession.is(VillagerProfession.SHEPHERD)) {
                SheepFluffParticleOptions particle = new SheepFluffParticleOptions(ClientPacketHandlers.getColorForShepherdWoolFluff(professionLevel, random), -1, false);
                for (int i = 0; i < 10; ++i) {
                    level.addParticle((ParticleOptions)particle, (double)pos.getX() + random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + random.nextDouble(), MathUtil.nextNonAbsDouble(random), random.nextDouble(), MathUtil.nextNonAbsDouble(random));
                }
            } else if (profession.is(VillagerProfession.FLETCHER)) {
                for (int i = 0; i < 8; ++i) {
                    level.addParticle((ParticleOptions)ModParticles.CHICKEN_FEATHER.get(), (double)pos.getX() + random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + random.nextDouble(), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.1));
                    level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.FLINT)), (double)pos.getX() + random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + random.nextDouble(), MathUtil.nextNonAbsDouble(random, 0.25), MathUtil.nextDouble(random, 0.25), MathUtil.nextNonAbsDouble(random, 0.25));
                }
            } else if ((profession.is(VillagerProfession.BUTCHER) || profession.is(VillagerProfession.ARMORER)) && state.hasProperty((Property)BlockStateProperties.LIT) && !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
                Block block = state.getBlock();
                BlockState litState = (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true));
                TickerManager.schedule(10, () -> block.animateTick(litState, (Level)level, pos, random));
                for (int i = 0; i < 2; ++i) {
                    block.animateTick(litState, (Level)level, pos, random);
                }
            }
        }
    }

    public static void handle(ClientLevel level, ClientBoundMooshroomShearedPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            if (!ModConfigs.ENTITIES.improvedMooshroomShearingEffects) {
                level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, mooshroom.getX(), mooshroom.getY(0.5), mooshroom.getZ(), 0.0, 0.0, 0.0);
                return;
            }
            RandomSource random = mooshroom.getRandom();
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)(mooshroom.getVariant() == MushroomCow.Variant.BROWN ? Blocks.BROWN_MUSHROOM_BLOCK : Blocks.RED_MUSHROOM_BLOCK)));
            for (int i = 0; i < 20; ++i) {
                level.addParticle((ParticleOptions)particle, mooshroom.getRandomX(1.0), mooshroom.getRandomY(), mooshroom.getRandomZ(1.0), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
            }
            mooshroom.spawnAnim();
        }
    }

    public static void handle(ClientLevel level, ClientBoundAnimalFedPayload payload) {
        Entity entity = level.getEntity(payload.animalId());
        ItemStack stack = payload.stack();
        if (entity instanceof Animal || entity instanceof Dolphin || entity instanceof Tadpole) {
            float volume;
            LivingEntity livingEntity = (LivingEntity)entity;
            RandomSource random = entity.getRandom();
            ModAnimalFedEffectSettings.Settings settings = ModAnimalFedEffectSettings.getSetting(entity.getType());
            if (ModConfigs.ENTITIES.animalFeedingParticles) {
                for (int i = 0; i < 16; ++i) {
                    ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, (ItemStack)settings.stackReplacer().apply(stack)), livingEntity, (Level)level, random, settings.offset(), Util.getPartialTicks());
                }
            }
            if ((volume = ((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue()) > 0.0f && !entity.isSilent()) {
                Util.playClientSound(entity, ClientPacketHandlers.getEatSound(livingEntity, stack, settings), entity.getSoundSource(), volume, livingEntity.getVoicePitch());
            }
        }
    }

    public static void handle(ClientLevel level, ClientBoundDrankPotionPayload payload) {
        LivingEntity livingEntity;
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive()) {
            ParticleSpawnUtil.spawnPotionRings(livingEntity);
        }
    }

    public static void handle(ClientLevel level, ClientBoundDispenseBucketPayload payload) {
        BlockPos pos = payload.pos();
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            pos = pos.relative(direction);
        }
        ParticleSpawnUtil.spawnBucketParticles((Level)level, pos, payload.stack());
    }

    public static void handle(ClientLevel level, ClientBoundSheepShearPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (ModConfigs.ENTITIES.sheepShearFluff) {
                ParticleSpawnUtil.spawnSheepFluff(sheep, 7);
            }
        }
    }

    public static void handle(ClientLevel level, ClientBoundEntityLandInFluidPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity != null) {
            ParticleType<SplashEmitterParticleOptions> particleType = payload.isLava() ? ModParticles.LAVA_SPLASH_EMITTER.get() : ModParticles.WATER_SPLASH_EMITTER.get();
            ParticleSpawnUtil.spawnSplashEffects(entity, (Level)level, particleType, payload.y(), payload.yVelocity());
        }
    }

    public static void handle(ClientLevel level, ClientBoundExplosionPayload payload) {
        if (ModConfigs.ENTITIES.splashes.explosionsCauseSplashes) {
            float radius = payload.radius();
            Vec3 position = payload.position();
            BlockPos pos = BlockPos.containing((Position)position);
            FluidState fluidState = level.getFluidState(pos);
            if (!fluidState.isEmpty()) {
                int blockY;
                int y = blockY = pos.getY();
                while ((double)y < (double)blockY + (double)radius * 1.5 + 1.0) {
                    BlockPos currentPos = pos.atY(y);
                    FluidState currentFluidState = level.getFluidState(currentPos);
                    if (!fluidState.getType().isSame(currentFluidState.getType())) {
                        ParticleType<SplashEmitterParticleOptions> type;
                        if (level.getBlockState(currentPos).isSolidRender()) {
                            return;
                        }
                        Object object = fluidState.is(FluidTags.WATER) ? ModParticles.WATER_SPLASH_EMITTER.get() : (type = fluidState.is(FluidTags.LAVA) ? ModParticles.LAVA_SPLASH_EMITTER.get() : null);
                        if (type != null) {
                            BlockPos surfacePos = currentPos.below();
                            FluidState surfaceFluidState = level.getFluidState(surfacePos);
                            float scale = radius - (float)(y - blockY) / radius;
                            level.addAlwaysVisibleParticle((ParticleOptions)new SplashEmitterParticleOptions(type, scale, scale * (scale * 0.1f), -1.0f, -1), true, position.x(), (double)((float)surfacePos.getY() + surfaceFluidState.getHeight((BlockGetter)level, surfacePos)) + 0.01, position.z(), 0.0, 0.0, 0.0);
                        }
                        return;
                    }
                    ++y;
                }
            }
        }
    }

    public static void handle(ClientLevel level, ClientBoundCopperGolemPayload payload) {
        Entity entity = level.getEntity(payload.entityId());
        if (entity instanceof CopperGolem) {
            CopperGolem copperGolem = (CopperGolem)entity;
            RandomSource random = copperGolem.getRandom();
            ClientBoundCopperGolemPayload.Action action = payload.action();
            BlockPos pos = copperGolem.blockPosition();
            if (action == ClientBoundCopperGolemPayload.Action.WAX_ON) {
                for (int i = 0; i < random.nextIntBetweenInclusive(3, 5) * 6; ++i) {
                    level.addParticle((ParticleOptions)ParticleTypes.WAX_ON, copperGolem.getRandomX(1.5), copperGolem.getRandomY(), copperGolem.getRandomZ(1.5), MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5), MathUtil.nextNonAbsDouble(random, 0.5));
                }
                level.playLocalSound(copperGolem.getX(), copperGolem.getY(), copperGolem.getZ(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return;
            }
            WeatheringCopper.WeatherState weatherState = copperGolem.getWeatherState();
            if (ClientPacketHandlers.tryDoVanillaEffects(level, copperGolem, action, pos, weatherState)) {
                return;
            }
            BlockParticleOption options = new BlockParticleOption(ModParticles.BLOCK_NO_MOMENTUM.get(), ClientPacketHandlers.getStateForAction(action, weatherState));
            for (int i = 0; i < 20; ++i) {
                level.addParticle((ParticleOptions)options, copperGolem.getRandomX(1.5), copperGolem.getRandomY() + MathUtil.nextDouble(random, 0.5), copperGolem.getRandomZ(1.5), 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean tryDoVanillaEffects(ClientLevel level, CopperGolem copperGolem, ClientBoundCopperGolemPayload.Action action, BlockPos pos, WeatheringCopper.WeatherState weatherState) {
        int stateId = Block.getId((BlockState)(switch (weatherState) {
            default -> throw new MatchException(null, null);
            case WeatheringCopper.WeatherState.UNAFFECTED -> Blocks.COPPER_BLOCK;
            case WeatheringCopper.WeatherState.EXPOSED -> Blocks.EXPOSED_COPPER;
            case WeatheringCopper.WeatherState.WEATHERED -> Blocks.WEATHERED_COPPER;
            case WeatheringCopper.WeatherState.OXIDIZED -> Blocks.OXIDIZED_COPPER;
        }).defaultBlockState());
        if (action == ClientBoundCopperGolemPayload.Action.SCRAPE && ModConfigs.ITEMS.axeScrapeParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
            level.levelEvent((Entity)copperGolem, 3005, pos, stateId);
            return ModConfigs.ITEMS.axeScrapeParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA;
        }
        if (action == ClientBoundCopperGolemPayload.Action.WAX_OFF && ModConfigs.ITEMS.axeWaxOffParticlesDisplayType != ReplacedParticlesDisplayType.DEFAULT) {
            level.levelEvent((Entity)copperGolem, 3004, pos, stateId);
            return ModConfigs.ITEMS.axeWaxOffParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA;
        }
        return false;
    }

    private static BlockState getStateForAction(ClientBoundCopperGolemPayload.Action action, WeatheringCopper.WeatherState weatherState) {
        if (action == ClientBoundCopperGolemPayload.Action.SCRAPE) {
            return (switch (weatherState) {
                default -> throw new MatchException(null, null);
                case WeatheringCopper.WeatherState.UNAFFECTED -> Blocks.COPPER_GOLEM_STATUE;
                case WeatheringCopper.WeatherState.EXPOSED -> Blocks.EXPOSED_COPPER_GOLEM_STATUE;
                case WeatheringCopper.WeatherState.WEATHERED -> Blocks.WEATHERED_COPPER_GOLEM_STATUE;
                case WeatheringCopper.WeatherState.OXIDIZED -> Blocks.OXIDIZED_COPPER_GOLEM_STATUE;
            }).defaultBlockState();
        }
        return Blocks.HONEY_BLOCK.defaultBlockState();
    }

    private static SoundEvent getEatSound(LivingEntity entity, ItemStack stack, ModAnimalFedEffectSettings.Settings settings) {
        Supplier<SoundEvent> overrideSound = settings.sound();
        if (overrideSound != null) {
            return overrideSound.get();
        }
        return Util.getEntityEatSound(entity, stack);
    }

    private static DyeColor getColorForShepherdWoolFluff(int professionLevel, RandomSource random) {
        if (professionLevel >= 2 && random.nextDouble() < 0.5) {
            return DyeColor.values()[random.nextInt(DyeColor.values().length)];
        }
        return COMMON_SHEPHERD_WOOL_COLORS.get(random.nextInt(COMMON_SHEPHERD_WOOL_COLORS.size()));
    }

    private static ParticleOptions getParticleForFallingBlock(ClientLevel level, BlockPos pos, BlockState state) {
        if (Block.canSupportRigidBlock((BlockGetter)level, (BlockPos)pos.below())) {
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, state.getBlock(), state, pos);
            return new DustParticleOptions(color, 1.0f);
        }
        return new BlockParticleOption(ParticleTypes.FALLING_DUST, state);
    }

    private static int getFallingBlockDustColor(ClientLevel level, Block block, BlockState state, BlockPos pos) {
        BrushableBlock brushableBlock;
        Block turnsIntoBlock;
        if (block instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)block;
            return fallingBlock.getDustColor(state, (BlockGetter)level, pos);
        }
        if (block instanceof BrushableBlock && (turnsIntoBlock = (brushableBlock = (BrushableBlock)block).getTurnsInto()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return Minecraft.getInstance().getBlockColors().getColor(state, (Level)level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundEntityFellPayload.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPayload.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPayload.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPayload.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

