/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.ParticleAnimation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;

public class BaseAnimatedParticle
extends SingleQuadParticle {
    private final ParticleAnimation animation;

    public BaseAnimatedParticle(ClientLevel level, double x, double y, double z, ParticleAnimation animation) {
        super(level, x, y, z, animation.getSpriteForFrame());
        this.animation = animation;
        this.lifetime = animation.getAnimationLifetime();
        this.updateSprite();
    }

    protected BaseAnimatedParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, ParticleAnimation animation) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, animation.getSpriteForFrame());
        this.animation = animation;
        this.lifetime = animation.getAnimationLifetime();
        this.updateSprite();
    }

    public void tick() {
        super.tick();
        if (!this.removed) {
            this.animation.tick();
            this.updateSprite();
        }
    }

    private void updateSprite() {
        if (!this.removed) {
            this.setSprite(this.animation.getSpriteForFrame());
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }
}

