/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;

public class CustomTerrainParticle
extends TerrainParticle {
    public static final ResourceLocation COMPOST_TEXTURE = ResourceLocation.parse((String)"minecraft:block/composter_compost");
    private final SingleQuadParticle.Layer renderType;

    public CustomTerrainParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SingleQuadParticle.Layer renderType) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, Blocks.AIR.defaultBlockState());
        this.renderType = renderType;
        this.hasPhysics = true;
    }

    public SingleQuadParticle.Layer getLayer() {
        return this.renderType;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            CustomTerrainParticle particle = new CustomTerrainParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, SingleQuadParticle.Layer.OPAQUE);
            particle.setSprite(this.sprites.get(random));
            return particle;
        }
    }

    public record CompostProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            CustomTerrainParticle particle = new CustomTerrainParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, SingleQuadParticle.Layer.TERRAIN);
            particle.setSprite(Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(COMPOST_TEXTURE));
            return particle;
        }
    }
}

