/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.BubbleSetter;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class DrowningBubbleParticle
extends BubbleParticle {
    public DrowningBubbleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.alpha = ((Float)ModConfigs.ENTITIES.humanoids.drowningBubbleAlpha.get()).floatValue();
        this.lifetime *= 3;
        if (ModConfigs.ENTITIES.humanoids.forceDrowningBubblesToColumn) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        }
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            DrowningBubbleParticle particle = new DrowningBubbleParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites.get(random));
            if (BCWPPackManager.isPackLoaded()) {
                ((BubbleSetter)((Object)particle)).subtleEffects$setupBubble(this.sprites, false);
            }
            return particle;
        }
    }
}

