/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class DustCloudParticle
extends SingleQuadParticle {
    private final SpriteSet sprites;
    private final double ySpeed;
    private final Minecraft minecraft = Minecraft.getInstance();

    protected DustCloudParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int maxLifeTime, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, 0.0, zSpeed, sprites.first());
        this.sprites = sprites;
        this.ySpeed = ySpeed;
        this.gravity = 0.1f;
        this.lifetime = Math.max(this.random.nextInt(maxLifeTime), maxLifeTime - 10);
        this.speedUpWhenYMotionIsBlocked = true;
        this.alpha = ((Float)ModConfigs.ENTITIES.dustClouds.alpha.get()).floatValue();
        this.setSpriteFromAge(sprites);
        this.scale(3.0f * ((Float)ModConfigs.ENTITIES.dustClouds.scale.get()).floatValue());
        this.setSize(0.25f, 0.25f);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        if (ModConfigs.ENTITIES.dustClouds.lessViewBlocking && this.minecraft.options.getCameraType().isFirstPerson() && camera.getEntity().distanceToSqr(this.x, this.y, this.z) < 4.0) {
            return;
        }
        super.extract(state, camera, partialTicks);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (this.age >= this.lifetime / 3 * 2) {
            this.yd *= this.ySpeed / (double)(this.random.nextInt(3, 7) * 1000);
            this.alpha -= 0.1f;
        }
        if (this.onGround || this.alpha <= 0.0f) {
            this.remove();
        }
    }

    public record LargeProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource randomSource) {
            return new DustCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 35, this.sprites);
        }
    }

    public record SmallProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource randomSource) {
            return new DustCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 25, this.sprites);
        }
    }
}

