/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class EggSplatParticle
extends FlatPlaneParticle {
    private final Direction direction;

    protected EggSplatParticle(ClientLevel level, double x, double y, double z, Direction direction, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
        this.direction = direction;
        this.rotation = direction.getRotation().rotateX(Util.radians(-90.0f));
        this.lifetime = 120;
        this.quadSize = 0.2f;
        if (direction.getAxis().isVertical()) {
            this.rotation.rotateZ(Util.radians(90 * this.random.nextInt(3)));
        }
    }

    public void tick() {
        super.tick();
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.getBlockState(pos.relative(this.direction)).isAir()) {
            this.remove();
            return;
        }
        if (Util.isSolidOrNotEmpty((Level)this.level, pos)) {
            this.remove();
            return;
        }
        int i = this.lifetime / 3 * 2;
        if (this.age == i && this.direction.getAxis().isHorizontal()) {
            this.gravity = 0.05f;
        }
        if (this.age >= i) {
            this.alpha = Mth.clamp((float)(this.alpha - 0.0125f), (float)0.0f, (float)1.0f);
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<DirectionParticleOptions>
    {
        public Particle createParticle(DirectionParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new EggSplatParticle(level, x, y, z, options.direction(), this.sprites.get(random));
        }
    }
}

