/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticleLayers;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class EnderEyePlacedRingParticle
extends FlatPlaneParticle {
    public static final int DEFAULT_COLOR = 0x7ABAAB;
    public static final float SIZE = 0.2501f;
    private final Particle.LifetimeAlpha lifetimeAlpha = new Particle.LifetimeAlpha(1.0f, 0.0f, 0.0f, 1.0f);

    protected EnderEyePlacedRingParticle(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
        this.lifetime = (Integer)ModConfigs.BLOCKS.enderEyePlacedRingsDuration.get();
        this.quadSize = 0.2501f;
        this.setSize(0.2501f, 0.2501f);
        this.alpha = this.lifetimeAlpha.startAlpha();
    }

    @Override
    protected void renderQuad(QuadParticleRenderState state, Camera camera, float partialTicks, Quaternionf rotation) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        this.renderQuad(state, new Quaternionf(), partialTicks, x, y, z + 0.2501f);
        this.renderQuad(state, new Quaternionf().rotateY(Util.radians(90.0f)), partialTicks, x - 0.2501f, y, z);
        this.renderQuad(state, new Quaternionf().rotateY(Util.radians(180.0f)), partialTicks, x, y, z - 0.2501f);
        this.renderQuad(state, new Quaternionf().rotateY(Util.radians(-90.0f)), partialTicks, x + 0.2501f, y, z);
    }

    protected void renderQuad(QuadParticleRenderState state, Quaternionf rotation, float partialTicks, float x, float y, float z) {
        this.renderQuad(state, rotation, partialTicks, x, y, z, false);
        this.renderQuad(state, rotation, partialTicks, x, y, z, true);
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return ModParticleLayers.getBlendedOrTransparent();
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            EnderEyePlacedRingParticle particle = new EnderEyePlacedRingParticle(level, x, y, z, this.sprites.get(random));
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }
}

