/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class FlatPlaneParticle
extends SingleQuadParticle {
    protected Quaternionf rotation = new Quaternionf();
    protected boolean renderBackFace = true;

    protected FlatPlaneParticle(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
    }

    protected FlatPlaneParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
    }

    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        Quaternionf rotation = new Quaternionf((Quaternionfc)this.rotation);
        if (this.roll != 0.0f) {
            rotation.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        this.renderQuad(state, camera, partialTicks, rotation);
    }

    protected void renderQuad(QuadParticleRenderState state, Camera camera, float partialTicks, Quaternionf rotation) {
        Vec3 vec3 = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - vec3.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - vec3.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - vec3.z());
        this.renderQuad(state, rotation, partialTicks, x, y, z, false);
        if (this.renderBackFace) {
            this.renderQuad(state, rotation, partialTicks, x, y, z, true);
        }
    }

    protected void renderQuad(QuadParticleRenderState state, Quaternionf rotation, float partialTicks, float x, float y, float z, boolean renderInverted) {
        if (renderInverted) {
            rotation.rotateY(Util.radians(-180.0f));
        }
        state.add(this.getLayer(), x, y, z, rotation.x, rotation.y, rotation.z, rotation.w, this.getQuadSize(partialTicks), this.getU0(), this.getU1(), this.getV0(), this.getV1(), ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol), this.getLightColor(partialTicks));
    }
}

