/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class HeartPopParticle
extends SingleQuadParticle {
    private final SpriteSet sprites;

    public HeartPopParticle(ClientLevel level, double x, double y, double z, double ySpeed, SpriteSet sprites) {
        super(level, x, y, z, sprites.first());
        this.sprites = sprites;
        this.xd = 0.0;
        this.yd = ySpeed;
        this.zd = 0.0;
        this.lifetime = 5;
        this.speedUpWhenYMotionIsBlocked = true;
        this.quadSize *= 1.5f;
        this.hasPhysics = false;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)((float)this.age + partialTicks / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new HeartPopParticle(level, x, y, z, ySpeed, this.sprites);
        }
    }
}

