/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PotionRingParticle
extends FlatPlaneParticle {
    @Nullable
    private final Entity entity;
    private final boolean hasEntity;
    private double yDistance;
    private final Particle.LifetimeAlpha fadeInLifetimeAlpha;
    private final Particle.LifetimeAlpha fadeOutLifetimeAlpha;

    protected PotionRingParticle(ClientLevel level, double x, double y, double z, @Nullable Entity entity, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
        this.fadeInLifetimeAlpha = new Particle.LifetimeAlpha(0.0f, ((Float)ModConfigs.ENTITIES.humanoids.potionRingsAlpha.get()).floatValue(), 0.0f, 0.5f);
        this.fadeOutLifetimeAlpha = new Particle.LifetimeAlpha(((Float)ModConfigs.ENTITIES.humanoids.potionRingsAlpha.get()).floatValue(), 0.0f, 0.5f, 1.0f);
        this.entity = entity;
        this.hasEntity = entity != null;
        this.yDistance = this.hasEntity ? y - entity.getY() : 0.0;
        this.lifetime = 10;
        this.alpha = 0.0f;
        this.quadSize = 0.2f;
        this.rotation.rotateX(-1.5707964f);
        this.scale(3.0f * ((Float)ModConfigs.ENTITIES.humanoids.potionRingsScale.get()).floatValue());
    }

    @Override
    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        this.alpha = Math.min(this.fadeInLifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks), this.fadeOutLifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks));
        super.extract(state, camera, partialTicks);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        float halfLife = (float)this.lifetime / 2.0f;
        this.yd += 0.25 / (double)halfLife * (double)((float)this.age > halfLife ? -1 : 1);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.move(0.0, this.yd, 0.0);
        this.yd *= (double)this.friction;
        if (this.hasEntity) {
            this.yDistance += this.y - this.yo;
            this.setPos(this.entity.getX(), this.entity.getY() + this.yDistance, this.entity.getZ());
        }
    }

    public void move(double x, double y, double z) {
        if (y != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorAndIntegerParticleOptions>
    {
        public Particle createParticle(ColorAndIntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            PotionRingParticle particle = new PotionRingParticle(level, x, y, z, level.getEntity(options.integer()), this.sprites.get(random));
            Util.setColorFromHex(particle, options.color());
            return particle;
        }
    }
}

