/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.RandomSource;

public class RippleParticle
extends FlatPlaneParticle {
    private final SpriteSet sprites;
    private final boolean translucent;

    protected RippleParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, boolean translucent, float scale) {
        super(level, x, y, z, sprites.first());
        this.sprites = sprites;
        this.translucent = translucent;
        this.rotation.rotateX(Util.radians(90.0f));
        this.setSpriteFromAge(sprites);
        this.scale(scale);
        this.lifetime = 5;
        if (translucent) {
            this.alpha = 0.2f;
        }
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    protected SingleQuadParticle.Layer getLayer() {
        if (this.translucent) {
            return SingleQuadParticle.Layer.TRANSLUCENT;
        }
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            RippleParticle particle = new RippleParticle(level, x, y, z, this.sprites, false, options.f());
            particle.setColor(0.871f, 0.478f, 0.133f);
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new RippleParticle(level, x, y, z, this.sprites, true, options.f());
        }
    }
}

