/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.FeatherParticle;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.color.ColorLerper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class SheepFluffParticle
extends FeatherParticle {
    private final boolean isJeb;
    private final Entity sheep;

    protected SheepFluffParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SheepFluffParticleOptions options, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        int sheepId = options.sheepId();
        this.isJeb = options.isJeb();
        this.sheep = this.isJeb ? level.getEntity(sheepId) : null;
        this.gravity = 0.5f;
        if (!this.isJeb) {
            Util.setColorFromHex(this, ColorLerper.Type.SHEEP.getColor(options.color()));
        }
    }

    public void extract(QuadParticleRenderState reusedState, Camera renderInfo, float partialTicks) {
        if (this.isJeb) {
            Util.setColorFromHex(this, ColorLerper.getLerpedColor((ColorLerper.Type)ColorLerper.Type.SHEEP, (float)this.sheep.tickCount));
        }
        super.extract(reusedState, renderInfo, partialTicks);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SheepFluffParticleOptions>
    {
        public Particle createParticle(SheepFluffParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SheepFluffParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options, this.sprites.get(random));
        }
    }
}

