/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;

public class SneezeParticle
extends SingleQuadParticle {
    private final Particle.LifetimeAlpha lifetimeAlpha = new Particle.LifetimeAlpha(0.4f, 0.0f, 0.5f, 1.0f);
    private final SpriteSet sprites;

    protected SneezeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites.first());
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        Util.setRandomizedColor(this, this.random, 0.21f, 0.8f, 0.52f);
        this.alpha = this.lifetimeAlpha.startAlpha();
        this.friction = 0.98f;
        this.sprites = sprites;
        this.setSpriteFromAge(sprites);
    }

    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        super.extract(state, camera, partialTicks);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SneezeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

