/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.SparkType;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class SparkParticle
extends SingleQuadParticle {
    public static final List<Integer> DEFAULT_COLORS = List.of(Integer.valueOf(16766976), Integer.valueOf(16738816));
    public static final List<Integer> SOUL_COLORS = List.of(Integer.valueOf(6354426), Integer.valueOf(108460));
    public static final List<Integer> BLAZE_COLORS = List.of(Integer.valueOf(16775239), Integer.valueOf(16766248), Integer.valueOf(13727744), Integer.valueOf(9122817));
    public static final List<Integer> COPPER_COLORS = List.of(Integer.valueOf(4620877), Integer.valueOf(0x99EB99));

    protected SparkParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float lifeTimeModifier, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.friction = 0.96f;
        this.gravity = -0.1f;
        this.xd = this.xd * 0.1 + xSpeed;
        this.yd = this.yd * 0.1 + ySpeed;
        this.zd = this.zd * 0.1 + zSpeed;
        int i = this.random.nextInt(11);
        this.quadSize *= 0.75f * (float)i / 10.0f * ((Float)ModConfigs.GENERAL.sparksScale.get()).floatValue();
        this.lifetime = (int)(20.0 / ((double)this.random.nextFloat() * 0.8 + 0.2) * (double)i / (double)lifeTimeModifier);
        this.lifetime = Math.max(this.lifetime, 1);
        this.hasPhysics = true;
        this.speedUpWhenYMotionIsBlocked = true;
    }

    public static ColorParticleOption create(SparkType sparkType, RandomSource random) {
        return SparkParticle.create(sparkType, random, DEFAULT_COLORS);
    }

    public static ColorParticleOption create(SparkType sparkType, RandomSource random, List<Integer> colors) {
        return ColorParticleOption.create(sparkType.getType().get(), (int)colors.get(random.nextInt(colors.size())));
    }

    public static ColorParticleOption createSoul(SparkType sparkType, RandomSource random) {
        return SparkParticle.create(sparkType, random, SOUL_COLORS);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public int getLightColor(float partialTick) {
        return 240;
    }

    public record MetalProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites.get(random));
            ((ParticleAccessor)((Object)particle)).setGravity(1.0f);
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }

    public record FloatingProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites.get(random));
            ((ParticleAccessor)((Object)particle)).setGravity(0.0f);
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }

    public record ShortLifeProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites.get(random));
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }

    public record LongLifeProvider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public Particle createParticle(ColorParticleOption options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 10.0f, this.sprites.get(random));
            particle.setColor(options.getRed(), options.getGreen(), options.getBlue());
            return particle;
        }
    }
}

