/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;

public class SplashRippleParticle
extends FlatPlaneParticle {
    private final BlockPos.MutableBlockPos pos;
    private final SpriteSet sprites;
    private final TagKey<Fluid> fluidTag;
    private final boolean glowing;
    private boolean shouldAnimate = false;

    protected SplashRippleParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, float xScale, TagKey<Fluid> fluidTag, boolean glowing, RandomSource random) {
        super(level, x, y, z, sprites.first());
        this.sprites = sprites;
        this.fluidTag = fluidTag;
        this.glowing = glowing;
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        this.rotation = this.rotation.rotateX(1.5707964f);
        this.lifetime = 15;
        xScale /= 2.0f;
        xScale -= xScale * 0.0625f * 4.0f;
        this.quadSize = xScale;
        this.setSize(xScale, 0.1f);
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        this.pos.set(this.x, this.y, this.z);
        if (!this.level.getFluidState((BlockPos)this.pos).is(this.fluidTag) && !Util.getCauldronFluid(this.level.getBlockState((BlockPos)this.pos)).is(this.fluidTag)) {
            this.remove();
            return;
        }
        if (this.age++ >= this.lifetime) {
            if (this.shouldAnimate) {
                this.remove();
                return;
            }
            this.shouldAnimate = true;
            this.lifetime = 20;
            this.age = 0;
        }
        this.quadSize += 0.005f;
        if (this.shouldAnimate) {
            this.setSpriteFromAge(this.sprites);
        }
    }

    protected int getLightColor(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.getLightColor(partialTick);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (TagKey<Fluid>)FluidTags.LAVA, true, random);
            if (((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() == 0.0f) {
                particle.setAlpha(0.0f);
            }
            return particle;
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            SplashRippleParticle particle = new SplashRippleParticle(level, x, y, z, this.sprites, options.f(), (TagKey<Fluid>)FluidTags.WATER, false, random);
            int waterColor = ((Biome)level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.setColor(whiteIntensity + colorIntensity * ((float)(waterColor >> 16 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor >> 8 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(waterColor & 0xFF) / 255.0f));
            }
            particle.setAlpha(((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue());
            return particle;
        }
    }
}

