/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.BaseWaterfallParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;

public class WaterfallDropletParticle
extends BaseWaterfallParticle {
    protected WaterfallDropletParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, 0.0, 0.0, 0.0, new Particle.LifetimeAlpha(0.7f, 0.0f, 0.5f, 0.8f), sprite);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.gravity = 0.3f;
        this.lifetime = 12;
        this.quadSize = Mth.nextFloat((RandomSource)this.random, (float)0.0625f, (float)0.125f);
        this.setSize(this.quadSize, this.quadSize);
        int waterColor = ((Biome)level.getBiome(BlockPos.containing((double)x, (double)y, (double)z)).value()).getWaterColor();
        float colorIntensity = Mth.nextFloat((RandomSource)this.random, (float)0.2f, (float)0.5f);
        float whiteIntensity = 1.0f - colorIntensity;
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        this.setColor(whiteIntensity + colorIntensity * red, whiteIntensity + colorIntensity * green, whiteIntensity + colorIntensity * blue);
    }

    @Override
    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new WaterfallDropletParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites.get(random));
        }
    }
}

