/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.emitter;

import einstein.subtle_effects.configs.entities.HumanoidConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.ColorAndIntegerParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class PotionEmitter
extends NoRenderParticle {
    private final int color;
    private final int entityId;
    @Nullable
    private final Entity entity;

    protected PotionEmitter(ClientLevel level, double x, double y, double z, int color, int entityId) {
        super(level, x, y, z);
        this.color = color;
        this.entityId = entityId;
        this.entity = level.getEntity(entityId);
        this.lifetime = 1;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.entity != null) {
            this.x = this.entity.getX();
            this.y = this.entity.getY();
            this.z = this.entity.getZ();
        }
        if (ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.BOTH || ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.RINGS_ONLY) {
            for (int i = 0; i < 3; ++i) {
                this.level.addParticle((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_RING.get(), this.color, this.entityId), this.x, this.y - 0.1 + 0.4 * (double)i, this.z, 0.0, 0.0, 0.0);
            }
        }
        if (ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.BOTH || ModConfigs.ENTITIES.humanoids.potionRingsParticleType == HumanoidConfigs.PotionRingsParticleType.DOTS_ONLY) {
            float scale = ((Float)ModConfigs.ENTITIES.humanoids.potionRingsScale.get()).floatValue();
            for (int i = 0; i < 20; ++i) {
                this.level.addParticle((ParticleOptions)new ColorAndIntegerParticleOptions(ModParticles.POTION_DOT.get(), this.color, this.entityId), this.x + MathUtil.nextNonAbsDouble(this.random, 0.75 * (double)scale), this.y + this.random.nextDouble() - 0.5, this.z + MathUtil.nextNonAbsDouble(this.random, 0.75 * (double)scale), 0.0, 0.0, 0.0);
            }
        }
    }

    public record Provider() implements ParticleProvider<ColorAndIntegerParticleOptions>
    {
        public Particle createParticle(ColorAndIntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new PotionEmitter(level, x, y, z, options.color(), options.integer());
        }
    }
}

