/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.provider;

import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.ParticleAccessor;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluids;

public class ResinDripParticleProviders {
    private static void setProperties(DripParticle particle, @Nullable Float gravity, @Nullable Integer lifeTime) {
        if (gravity != null) {
            ((ParticleAccessor)particle).setGravity(gravity.floatValue());
        }
        if (lifeTime != null) {
            particle.setLifetime(lifeTime.intValue());
        }
        particle.setColor(0.925f, 0.447f, 0.078f);
    }

    public record LandingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            DripParticle.DripLandParticle particle = new DripParticle.DripLandParticle(level, x, y, z, Fluids.EMPTY, this.sprites.get(random));
            ResinDripParticleProviders.setProperties((DripParticle)particle, null, (int)(28.0 / (Math.random() * 0.8 + 0.2)));
            return particle;
        }
    }

    public record FallingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            DripParticle.FallAndLandParticle particle = new DripParticle.FallAndLandParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)ModParticles.LANDING_RESIN.get(), this.sprites.get(random));
            ResinDripParticleProviders.setProperties((DripParticle)particle, Float.valueOf(0.01f), null);
            return particle;
        }
    }

    public record DrippingResinDropProvider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            DripParticle.DripHangParticle particle = new DripParticle.DripHangParticle(level, x, y, z, Fluids.EMPTY, (ParticleOptions)ModParticles.FALLING_RESIN.get(), this.sprites.get(random));
            ResinDripParticleProviders.setProperties((DripParticle)particle, Float.valueOf(((ParticleAccessor)particle).getGravity() * 0.01f), 100);
            return particle;
        }
    }
}

