/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPayload;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_8170;

public class ClientPacketHandlers {
    public static void handle(class_638 level, ClientBoundEntityFellPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, payload.y(), payload.distance(), payload.fallDamage(), ClientPacketHandlers.getEntityFellConfig(payload));
        }
    }

    public static void handle(class_638 level, ClientBoundEntitySpawnSprintingDustCloudsPayload payload) {
        class_1297 class_12972 = level.method_8469(payload.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            int ySpeedModifier = 5;
            if (livingEntity instanceof class_1584) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (class_1937)level, livingEntity.method_59922(), ySpeedModifier);
        }
    }

    public static void handle(class_638 level, ClientBoundSpawnSnoreParticlePayload payload) {
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.method_8406((class_2394)ModParticles.SNORING.get(), payload.x(), payload.y(), payload.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(class_638 level, ClientBoundBlockDestroyEffectsPayload payload) {
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(payload)) {
            class_2338 pos = payload.pos();
            class_2680 state = class_2248.method_9531((int)payload.stateId());
            class_2498 soundType = state.method_26231();
            level.method_31595(pos, state);
            level.method_45446(pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundXPBottleEffectsPayload payload) {
        int i;
        class_2338 pos = payload.pos();
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        class_5819 random = level.method_8409();
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.method_20290(2002, pos, -13083194);
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ENTITIES.xpBottleParticlesDensity.get(); ++i) {
                double d = random.method_43058() * 4.0;
                double d1 = random.method_43058() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.method_8406((class_2394)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.field_1352 + xPower * 0.1, vec3.field_1351 + 0.3, vec3.field_1350 + zPower * 0.1, xPower, 0.01 + random.method_43058() * 0.5, zPower);
            }
        }
        if (ModConfigs.ENTITIES.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8436)), vec3.field_1352, vec3.field_1351, vec3.field_1350, random.method_43059() * 0.15, random.method_43058() * 0.2, random.method_43059() * 0.15);
            }
            level.method_45446(pos, class_3417.field_14839, class_3419.field_15254, 1.0f, random.method_43057() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(class_638 level, ClientBoundFallingBlockLandPayload payload) {
        class_2338 pos = payload.pos();
        class_2680 state = class_2248.method_9531((int)payload.stateId());
        class_2248 block = state.method_26204();
        if (ModConfigs.BLOCKS.fallingBlocks.landSound && !(block instanceof class_2199)) {
            class_2498 soundType = state.method_26231();
            Util.playClientSound(pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.landDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            class_5819 random = level.method_8409();
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, block, state, pos);
            class_2390 options = new class_2390(color, 1.0f);
            for (int i = 0; i < 25; ++i) {
                boolean b = random.method_43056();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.method_8406((class_2394)options, (double)pos.method_10263() + 0.5 + (b ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.method_10264() + MathUtil.nextDouble(random, 0.3), (double)pos.method_10260() + 0.5 + (!b ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), b ? (double)(50 * xSign) : 0.0, 0.3, !b ? (double)(50 * zSign) : 0.0);
            }
        }
    }

    public static void handle(class_638 level, ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles) {
            class_5819 random = level.method_8409();
            ParticleSpawnUtil.spawnCompostParticles((class_1937)level, payload.pos(), (class_2394)new class_2392(class_2398.field_11218, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    private static int getFallingBlockDustColor(class_638 level, class_2248 block, class_2680 state, class_2338 pos) {
        class_8170 brushableBlock;
        class_2248 turnsIntoBlock;
        if (block instanceof class_2346) {
            class_2346 fallingBlock = (class_2346)block;
            return fallingBlock.method_10130(state, (class_1922)level, pos);
        }
        if (block instanceof class_8170 && (turnsIntoBlock = (brushableBlock = (class_8170)block).method_49810()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return class_310.method_1551().method_1505().method_1691(state, (class_1937)level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPayload.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPayload packet) {
        return switch (packet.config()) {
            default -> throw new MatchException(null, null);
            case ClientBoundEntityFellPayload.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPayload.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPayload.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPayload.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }
}

