/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.List;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9381;

public class SparkParticle
extends class_4003 {
    public static final List<Integer> DEFAULT_COLORS = List.of(Integer.valueOf(16766976), Integer.valueOf(16738816));
    public static final List<Integer> SOUL_COLORS = List.of(Integer.valueOf(6354426), Integer.valueOf(108460));

    protected SparkParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float lifeTimeModifier, class_4002 sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.field_28786 = 0.96f;
        this.field_3844 = -0.1f;
        this.field_3852 = this.field_3852 * 0.1 + xSpeed;
        this.field_3869 = this.field_3869 * 0.1 + ySpeed;
        this.field_3850 = this.field_3850 * 0.1 + zSpeed;
        int i = this.field_3840.method_43048(11);
        this.field_17867 *= 0.75f * (float)i / 10.0f * ((Float)ModConfigs.GENERAL.sparksScale.get()).floatValue();
        this.field_3847 = (int)(20.0 / ((double)this.field_3840.method_43057() * 0.8 + 0.2) * (double)i / (double)lifeTimeModifier);
        this.field_3847 = Math.max(this.field_3847, 1);
        this.field_3862 = true;
        this.field_28787 = true;
        this.method_18140(sprites);
    }

    public static class_9381 create(SparkType sparkType, class_5819 random) {
        return SparkParticle.create(sparkType, random, DEFAULT_COLORS);
    }

    public static class_9381 create(SparkType sparkType, class_5819 random, List<Integer> colors) {
        return class_9381.method_58256(sparkType.getType().get(), (int)colors.get(random.method_43048(colors.size())));
    }

    public static class_9381 createSoul(SparkType sparkType, class_5819 random) {
        return SparkParticle.create(sparkType, random, SOUL_COLORS);
    }

    public class_3999 method_18122() {
        return class_3999.field_17828;
    }

    public float method_18132(float scaleFactor) {
        return this.field_17867 * class_3532.method_15363((float)(((float)this.field_3866 + scaleFactor) / (float)this.field_3847 * 32.0f), (float)0.0f, (float)1.0f);
    }

    public int method_3068(float partialTick) {
        return Util.getLightColor(super.method_3068(partialTick));
    }

    public record MetalProvider(class_4002 sprites) implements class_707<class_9381>
    {
        public class_703 createParticle(class_9381 options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            particle.field_3844 = 1.0f;
            particle.method_3084(options.method_58259(), options.method_58263(), options.method_58264());
            return particle;
        }
    }

    public record FloatingProvider(class_4002 sprites) implements class_707<class_9381>
    {
        public class_703 createParticle(class_9381 options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            particle.field_3844 = 0.0f;
            particle.method_3084(options.method_58259(), options.method_58263(), options.method_58264());
            return particle;
        }
    }

    public record ShortLifeProvider(class_4002 sprites) implements class_707<class_9381>
    {
        public class_703 createParticle(class_9381 options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 20.0f, this.sprites);
            particle.method_3084(options.method_58259(), options.method_58263(), options.method_58264());
            return particle;
        }
    }

    public record LongLifeProvider(class_4002 sprites) implements class_707<class_9381>
    {
        public class_703 createParticle(class_9381 options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkParticle particle = new SparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, 10.0f, this.sprites);
            particle.method_3084(options.method_58259(), options.method_58263(), options.method_58264());
            return particle;
        }
    }
}

