/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.tickers;

import einstein.subtle_effects.tickers.ScheduledTicker;
import einstein.subtle_effects.tickers.Ticker;
import einstein.subtle_effects.tickers.entity_tickers.EntityTickerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public class TickerManager {
    private static final List<Ticker> ADD_QUEUE = new ArrayList<Ticker>();
    private static final List<Ticker> TICKERS = new ArrayList<Ticker>();
    private static final List<Ticker> REMOVE_QUEUE = new ArrayList<Ticker>();

    public static void scheduleNext(Runnable runnable) {
        TickerManager.schedule(1, runnable);
    }

    public static void schedule(int tickDelay, Runnable runnable) {
        TickerManager.add(new ScheduledTicker(tickDelay, runnable));
    }

    public static void add(Ticker ticker) {
        ADD_QUEUE.add(ticker);
    }

    public static void tick() {
        TICKERS.addAll(ADD_QUEUE);
        ADD_QUEUE.clear();
        TICKERS.forEach(ticker -> {
            if (!ticker.isRemoved()) {
                ticker.tick();
                return;
            }
            REMOVE_QUEUE.add((Ticker)ticker);
        });
        REMOVE_QUEUE.forEach(TICKERS::remove);
        REMOVE_QUEUE.clear();
    }

    public static void clear(@Nullable class_1937 level) {
        ADD_QUEUE.clear();
        TICKERS.clear();
        REMOVE_QUEUE.clear();
        EntityTickerManager.clear(level);
    }
}

