/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle.bubbles;

import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.DrowningBubbleParticle;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.BubbleSetter;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_653;
import net.minecraft.class_655;
import net.minecraft.class_736;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_655.class, class_653.class, class_736.class})
public abstract class BubbleParticleMixin
extends class_4003
implements BubbleSetter {
    @Unique
    private class_1058 subtleEffects$overlaySprite;
    @Unique
    private boolean subtleEffects$playsSound;
    @Unique
    private int subtleEffects$waterColor;

    protected BubbleParticleMixin(class_638 level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        this.subtleEffects$waterColor = ((class_1959)this.field_3851.method_23753(pos).comp_349()).method_8687();
        if (!this.method_3086()) {
            float volume = ((Float)ModConfigs.GENERAL.poppingBubblesVolume.get()).floatValue();
            if (this.subtleEffects$playsSound && volume > 0.0f && !this.field_3851.method_22351(pos)) {
                this.field_3851.method_8486(this.field_3874, this.field_3854, this.field_3871, class_3417.field_15065, class_3419.field_15256, (float)class_3532.method_15395((class_5819)this.field_3840, (int)1, (int)4) * volume, class_3532.method_15344((class_5819)this.field_3840, (float)1.0f, (float)1.3f), false);
            }
            if (ModConfigs.GENERAL.poppingBubbles) {
                if (this instanceof DrowningBubbleParticle) {
                    this.field_3851.method_8406((class_2394)ModParticles.DROWNING_BUBBLE_POP.get(), this.field_3874, this.field_3854, this.field_3871, this.field_3852, this.field_3869, this.field_3850);
                    return;
                }
                this.field_3851.method_8406((class_2394)class_2398.field_11241, this.field_3874, this.field_3854, this.field_3871, this.field_3852, this.field_3869, this.field_3850);
            }
        }
    }

    public void method_3074(class_4588 buffer, class_4184 camera, float partialTicks) {
        super.method_3074(buffer, camera, partialTicks);
        if (this.subtleEffects$overlaySprite != null) {
            Quaternionf quaternion;
            int lightColor = this.method_3068(partialTicks);
            float quadSize = this.method_18132(partialTicks);
            float u0 = this.subtleEffects$overlaySprite.method_4594();
            float u1 = this.subtleEffects$overlaySprite.method_4577();
            float v0 = this.subtleEffects$overlaySprite.method_4593();
            float v1 = this.subtleEffects$overlaySprite.method_4575();
            class_243 cameraPos = camera.method_19326();
            float x = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
            float y = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
            float z = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
            if (this.field_3839 == 0.0f) {
                quaternion = camera.method_23767();
            } else {
                quaternion = new Quaternionf((Quaternionfc)camera.method_23767());
                quaternion.rotateZ(class_3532.method_16439((float)partialTicks, (float)this.field_3857, (float)this.field_3839));
            }
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, -1.0f, quadSize, u0, v1, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, -1.0f, 1.0f, quadSize, u0, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, 1.0f, quadSize, u1, v0, lightColor);
            this.subtleEffects$renderVertex(buffer, quaternion, x, y, z, 1.0f, -1.0f, quadSize, u1, v1, lightColor);
        }
    }

    @Unique
    private void subtleEffects$renderVertex(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        float colorIntensity = 0.2f;
        float whiteIntensity = 1.0f - colorIntensity;
        buffer.method_22912((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).method_22913(u, v).method_22915(whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 16 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 8 & 0xFF) / 255.0f), whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor & 0xFF) / 255.0f), this.field_3841).method_22916(packedLight).method_1344();
    }

    @Override
    public void subtleEffects$setupBubble(class_4002 sprites, boolean playsSound) {
        List<class_1058> textures = Services.PARTICLE_HELPER.getSpritesFromSet(sprites);
        this.subtleEffects$playsSound = playsSound;
        if (textures != null && textures.size() > 1 && BCWPPackManager.isPackLoaded()) {
            this.method_18141(textures.get(0));
            this.subtleEffects$overlaySprite = textures.get(1);
        }
    }
}

