/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.entity.AbstractHorseAccessor;
import einstein.subtle_effects.networking.clientbound.ClientBoundAnimalFedPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDispenseBucketPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDrankPotionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityLandInFluidPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundMooshroomShearedPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundSheepShearPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundStonecutterUsedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundVillagerWorkPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPacket;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1433;
import net.minecraft.class_1438;
import net.minecraft.class_1453;
import net.minecraft.class_1472;
import net.minecraft.class_1496;
import net.minecraft.class_1584;
import net.minecraft.class_1646;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2390;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_4985;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7110;
import net.minecraft.class_8170;
import org.joml.Vector3f;

public class ClientPacketHandlers {
    private static final List<class_2248> MASON_STONECUTTER_USE_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10552, class_2246.field_10153, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474);
    private static final List<class_1767> COMMON_SHEPHERD_WOOL_COLORS = List.of(class_1767.field_7952, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957);

    public static void handle(ClientBoundEntityFellPacket packet) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 class_12972 = level.method_8469(packet.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, packet.y(), packet.distance(), packet.fallDamage(), ClientPacketHandlers.getEntityFellConfig(packet));
        }
    }

    public static void handle(ClientBoundEntitySpawnSprintingDustCloudsPacket packet) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 class_12972 = level.method_8469(packet.entityId());
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            int ySpeedModifier = 5;
            if (livingEntity instanceof class_1584) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (class_1937)level, livingEntity.method_6051(), ySpeedModifier);
        }
    }

    public static void handle(ClientBoundSpawnSnoreParticlePacket packet) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.method_8406((class_2394)ModParticles.SNORING.get(), packet.x(), packet.y(), packet.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(ClientBoundBlockDestroyEffectsPacket packet) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(packet)) {
            class_2338 pos = packet.pos();
            class_2680 state = class_2248.method_9531((int)packet.stateId());
            class_2498 soundType = state.method_26231();
            level.method_31595(pos, state);
            level.method_45446(pos, soundType.method_10595(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f, false);
        }
    }

    public static void handle(ClientBoundXPBottleEffectsPacket packet) {
        int i;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 pos = packet.pos();
        class_243 vec3 = class_243.method_24955((class_2382)pos);
        class_5819 random = level.method_8409();
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.method_20290(2002, pos, class_1844.method_8062((class_1842)class_1847.field_8991));
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ITEMS.projectiles.xpBottleParticlesDensity.get(); ++i) {
                double d = random.method_43058() * 4.0;
                double d1 = random.method_43058() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.method_8406((class_2394)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.field_1352 + xPower * 0.1, vec3.field_1351 + 0.3, vec3.field_1350 + zPower * 0.1, xPower, 0.01 + random.method_43058() * 0.5, zPower);
            }
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8436)), vec3.field_1352, vec3.field_1351, vec3.field_1350, random.method_43059() * 0.15, random.method_43058() * 0.2, random.method_43059() * 0.15);
            }
            level.method_45446(pos, class_3417.field_14839, class_3419.field_15254, 1.0f, random.method_43057() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(ClientBoundFallingBlockLandPayload payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 pos = payload.pos();
        class_2680 state = class_2248.method_9531((int)payload.stateId());
        class_2248 block = state.method_26204();
        if (ModConfigs.BLOCKS.fallingBlocks.onLandSound && !(block instanceof class_2199)) {
            class_2498 soundType = state.method_26231();
            Util.playClientSound(pos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.onLandDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            boolean isInWater = payload.isInWater() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            class_5819 random = level.method_8409();
            class_2400 options = isInWater ? class_2398.field_11247 : ClientPacketHandlers.getParticleForFallingBlock((class_1937)level, pos, state);
            for (int i = 0; i < 25; ++i) {
                boolean bool = random.method_43056();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.method_8406((class_2394)options, (double)pos.method_10263() + 0.5 + (bool ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.method_10264() + MathUtil.nextDouble(random, 0.3), (double)pos.method_10260() + 0.5 + (!bool ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)xSign : 0.0, 0.3, !bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)zSign : 0.0);
            }
        }
    }

    public static void handle(ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles && (!payload.wasFarmer() || ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles)) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            class_5819 random = level.method_8409();
            ParticleSpawnUtil.spawnCompostParticles((class_1937)level, payload.pos(), (class_2394)new class_2392(class_2398.field_11218, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    public static void handle(ClientBoundStonecutterUsedPayload payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 pos = payload.pos();
        ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, payload.stack(), pos, level.method_8320(pos));
    }

    public static void handle(ClientBoundVillagerWorkPacket payload) {
        block14: {
            class_2680 state;
            class_2338 pos;
            class_5819 random;
            int professionLevel;
            class_3852 profession;
            class_638 level;
            block17: {
                block16: {
                    block15: {
                        if (!ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles) {
                            return;
                        }
                        level = class_310.method_1551().field_1687;
                        if (level == null) {
                            return;
                        }
                        class_1297 entity = level.method_8469(payload.villagerId());
                        if (!(entity instanceof class_1646)) break block14;
                        class_1646 villager = (class_1646)entity;
                        class_3850 villagerData = villager.method_7231();
                        profession = villagerData.method_16924();
                        professionLevel = villagerData.method_16925();
                        random = level.method_8409();
                        pos = payload.pos();
                        state = level.method_8320(pos);
                        if (profession != class_3852.field_17059) break block15;
                        if (!ModConfigs.BLOCKS.cauldronUseParticles) {
                            return;
                        }
                        double fluidHeight = Util.getCauldronFillHeight(state);
                        class_2394 particle = Util.getCauldronParticle(state);
                        if (!(fluidHeight > 0.0) || particle == null) break block14;
                        for (int i = 0; i < 16; ++i) {
                            level.method_8406(particle, (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + fluidHeight, (double)pos.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
                        }
                        break block14;
                    }
                    if (profession != class_3852.field_17065) break block16;
                    ParticleSpawnUtil.spawnGrindstoneUsedParticles((class_1937)level, pos, state, random);
                    break block14;
                }
                if (profession != class_3852.field_17064) break block17;
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break block14;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (class_1937)level);
                break block14;
            }
            if (profession == class_3852.field_17061) {
                ParticleSpawnUtil.spawnStonecutterParticles((class_1937)level, new class_1799((class_1935)MASON_STONECUTTER_USE_BLOCKS.get(random.method_43048(MASON_STONECUTTER_USE_BLOCKS.size()))), pos, state);
            } else if (profession == class_3852.field_17063) {
                SheepFluffParticleOptions particle = new SheepFluffParticleOptions(ClientPacketHandlers.getColorForShepherdWoolFluff(professionLevel, random), -1, false);
                for (int i = 0; i < 10; ++i) {
                    level.method_8406((class_2394)particle, (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random), random.method_43058(), MathUtil.nextNonAbsDouble(random));
                }
            } else if (profession == class_3852.field_17058) {
                for (int i = 0; i < 8; ++i) {
                    level.method_8406((class_2394)ModParticles.CHICKEN_FEATHER.get(), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.1));
                    level.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_8145)), (double)pos.method_10263() + random.method_43058(), (double)(pos.method_10264() + 1), (double)pos.method_10260() + random.method_43058(), MathUtil.nextNonAbsDouble(random, 0.25), MathUtil.nextDouble(random, 0.25), MathUtil.nextNonAbsDouble(random, 0.25));
                }
            } else if ((profession == class_3852.field_17053 || profession == class_3852.field_17052) && state.method_28498((class_2769)class_2741.field_12548) && !((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue()) {
                class_2248 block = state.method_26204();
                class_2680 litState = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true));
                TickerManager.schedule(10, () -> ClientPacketHandlers.lambda$handle$0(block, litState, (class_1937)level, pos, random));
                for (int i = 0; i < 2; ++i) {
                    block.method_9496(litState, (class_1937)level, pos, random);
                }
            }
        }
    }

    public static void handle(ClientBoundMooshroomShearedPacket payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1438) {
            class_1438 mooshroom = (class_1438)entity;
            if (!ModConfigs.ENTITIES.improvedMooshroomShearingEffects) {
                level.method_8406((class_2394)class_2398.field_11236, mooshroom.method_23317(), mooshroom.method_23323(0.5), mooshroom.method_23321(), 0.0, 0.0, 0.0);
                return;
            }
            class_5819 random = mooshroom.method_6051();
            class_2392 particle = new class_2392(class_2398.field_11218, new class_1799((class_1935)(mooshroom.method_47847() == class_1438.class_4053.field_18110 ? class_2246.field_10580 : class_2246.field_10240)));
            for (int i = 0; i < 20; ++i) {
                level.method_8406((class_2394)particle, mooshroom.method_23322(1.0), mooshroom.method_23319(), mooshroom.method_23325(1.0), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
            }
            mooshroom.method_5990();
        }
    }

    public static void handle(ClientBoundAnimalFedPacket payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(payload.animalId());
        class_1799 stack = payload.stack();
        if (entity instanceof class_1429 || entity instanceof class_1433 || entity instanceof class_7110) {
            float volume;
            class_1309 livingEntity = (class_1309)entity;
            class_5819 random = level.method_8409();
            ModAnimalFedEffectSettings.Settings settings = ModAnimalFedEffectSettings.getSetting(entity.method_5864());
            if (ModConfigs.ENTITIES.animalFeedingParticles) {
                for (int i = 0; i < 16; ++i) {
                    ParticleSpawnUtil.spawnEntityFaceParticle((class_2394)new class_2392(class_2398.field_11218, (class_1799)settings.stackReplacer().apply(stack)), livingEntity, (class_1937)level, random, settings.offset(), Util.getPartialTicks());
                }
            }
            if ((volume = ((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue()) > 0.0f && !entity.method_5701()) {
                Util.playClientSound(entity, ClientPacketHandlers.getEatSound(livingEntity, stack, settings), entity.method_5634(), volume, livingEntity.method_6017());
            }
        }
    }

    public static void handle(ClientBoundDrankPotionPayload payload) {
        class_1309 livingEntity;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_5805()) {
            ParticleSpawnUtil.spawnPotionRings(livingEntity);
        }
    }

    public static void handle(ClientBoundDispenseBucketPayload payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 pos = payload.pos();
        class_2680 state = level.method_8320(pos);
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            pos = pos.method_10093(direction);
        }
        ParticleSpawnUtil.spawnBucketParticles((class_1937)level, pos, payload.stack());
    }

    public static void handle(ClientBoundSheepShearPayload payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            if (ModConfigs.ENTITIES.sheepShearFluff) {
                ParticleSpawnUtil.sheep(sheep);
            }
        }
    }

    public static void handle(ClientBoundEntityLandInFluidPayload payload) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(payload.entityId());
        if (entity != null) {
            class_2396<SplashEmitterParticleOptions> particleType = payload.isLava() ? ModParticles.LAVA_SPLASH_EMITTER.get() : ModParticles.WATER_SPLASH_EMITTER.get();
            ParticleSpawnUtil.spawnSplashEffects(entity, (class_1937)level, particleType, payload.y(), payload.yVelocity());
        }
    }

    private static class_3414 getEatSound(class_1309 entity, class_1799 stack, ModAnimalFedEffectSettings.Settings settings) {
        class_1496 horse;
        class_3414 horseEatSound;
        Supplier<class_3414> overrideSound = settings.sound();
        if (overrideSound != null) {
            return overrideSound.get();
        }
        if (entity instanceof class_1496 && (horseEatSound = ((AbstractHorseAccessor)(horse = (class_1496)entity)).getEatSound()) != null && !horseEatSound.equals(class_3417.field_20614)) {
            return horseEatSound;
        }
        class_3414 eatSound = entity.method_18869(stack);
        class_3414 stackEatSound = stack.method_21833();
        if (!eatSound.equals(class_3417.field_20614) && !eatSound.equals(stackEatSound)) {
            return eatSound;
        }
        if (entity instanceof class_4985) {
            return class_3417.field_23207;
        }
        if (entity instanceof class_1453) {
            return class_3417.field_14960;
        }
        return stackEatSound;
    }

    private static class_1767 getColorForShepherdWoolFluff(int professionLevel, class_5819 random) {
        if (professionLevel >= 2 && random.method_43058() < 0.5) {
            return class_1767.values()[random.method_43048(class_1767.values().length)];
        }
        return COMMON_SHEPHERD_WOOL_COLORS.get(random.method_43048(COMMON_SHEPHERD_WOOL_COLORS.size()));
    }

    private static class_2394 getParticleForFallingBlock(class_1937 level, class_2338 pos, class_2680 state) {
        if (class_2248.method_16361((class_1922)level, (class_2338)pos.method_10074())) {
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, state.method_26204(), state, pos);
            return new class_2390(new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f), 1.0f);
        }
        return new class_2388(class_2398.field_11206, state);
    }

    private static int getFallingBlockDustColor(class_1937 level, class_2248 block, class_2680 state, class_2338 pos) {
        class_8170 brushableBlock;
        class_2248 turnsIntoBlock;
        if (block instanceof class_2346) {
            class_2346 fallingBlock = (class_2346)block;
            return fallingBlock.method_10130(state, (class_1922)level, pos);
        }
        if (block instanceof class_8170 && (turnsIntoBlock = (brushableBlock = (class_8170)block).method_49810()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return class_310.method_1551().method_1505().method_1691(state, level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundEntityFellPacket.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPacket.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPacket.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPacket.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }

    private static /* synthetic */ void lambda$handle$0(class_2248 block, class_2680 litState, class_1937 level, class_2338 pos, class_5819 random) {
        block.method_9496(litState, level, pos, random);
    }
}

