/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1058;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SplashParticle
extends FlatPlaneParticle {
    private final boolean translucent;
    private final boolean glowing;
    private final class_6862<class_3611> fluidTag;
    private final class_4002 mainSprites;
    @Nullable
    private final class_4002 overlaySprites;
    private final class_4002 bottomSprites;
    private final boolean hasRipple;
    private final boolean hasOverlay;
    private final class_2338.class_2339 pos;
    private float xScale;
    private final float yScale;
    private class_1058 overlaySprite;
    private class_1058 bottomSprite;
    private boolean isRipplePhase = false;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;

    protected SplashParticle(class_638 level, double x, double y, double z, boolean translucent, boolean glowing, class_6862<class_3611> fluidTag, class_4002 mainSprites, @Nullable class_4002 overlaySprites, class_4002 bottomSprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.translucent = translucent;
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.mainSprites = mainSprites;
        this.overlaySprites = overlaySprites;
        this.bottomSprites = bottomSprites;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z).method_25503();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.field_3847 = 15;
        this.hasRipple = options.hasRipple();
        this.xScale = options.xScale() / 2.0f;
        this.yScale = options.yScale() / 2.0f;
        this.field_17867 = this.xScale;
        this.method_3080(this.xScale, this.yScale);
        this.setSpriteFromAge();
        this.setBottomSpriteFromAge();
    }

    public class_3999 method_18122() {
        if (this.translucent) {
            return class_3999.field_17829;
        }
        return class_3999.field_17828;
    }

    protected int method_3068(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.method_3068(partialTick);
    }

    public void method_3070() {
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.field_3851.method_8316((class_2338)this.pos).method_15767(this.fluidTag) && !Util.getCauldronFluid(this.field_3851.method_8320((class_2338)this.pos)).method_15791(this.fluidTag)) {
            this.method_3085();
            return;
        }
        if (this.field_3866++ >= this.field_3847) {
            if (!this.hasRipple || this.isRipplePhase) {
                this.method_3085();
                return;
            }
            this.isRipplePhase = true;
            this.field_3847 = 20;
            this.field_3866 = 0;
        }
        this.xScale += 0.005f;
        if (this.isRipplePhase) {
            this.setBottomSpriteFromAge();
            return;
        }
        this.setSpriteFromAge();
    }

    private void setSpriteFromAge() {
        this.field_17886 = this.mainSprites.method_18138(this.field_3866, this.field_3847);
        if (this.hasOverlay) {
            this.overlaySprite = this.overlaySprites.method_18138(this.field_3866, this.field_3847);
        }
    }

    private void setBottomSpriteFromAge() {
        this.bottomSprite = this.bottomSprites.method_18138(this.field_3866, this.field_3847);
    }

    @Override
    protected void renderQuad(class_4588 consumer, class_4184 camera, float partialTicks, Quaternionf rotation) {
        class_243 cameraPos = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float y = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float z = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        float overlayAlpha = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue();
        if (this.hasRipple) {
            this.renderQuad(consumer, new Quaternionf().rotateX(1.5707964f), partialTicks, x, y, z, false, this.bottomSprite.method_4594(), this.bottomSprite.method_4593(), this.bottomSprite.method_4577(), this.bottomSprite.method_4575(), this.xScale, this.xScale, this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
        }
        if (!this.isRipplePhase) {
            this.renderBox(consumer, partialTicks, x, y, z, this.method_18133(), this.method_18135(), this.method_18134(), this.method_18136(), this.field_3861, this.field_3842, this.field_3859, this.field_3841);
            if (this.hasOverlay) {
                this.renderBox(consumer, partialTicks, x, y, z, this.overlaySprite.method_4594(), this.overlaySprite.method_4593(), this.overlaySprite.method_4577(), this.overlaySprite.method_4575(), this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
            }
        }
    }

    private void renderBox(class_4588 consumer, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float red, float green, float blue, float alpha) {
        this.renderDoubleQuads(consumer, new Quaternionf(), partialTicks, x, y + this.yScale, z + this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(1.5707964f), partialTicks, x - this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY((float)Math.PI), partialTicks, x, y + this.yScale, z - this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(-1.5707964f), partialTicks, x + this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
    }

    protected void renderDoubleQuads(class_4588 consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, false, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, true, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
    }

    protected void renderQuad(class_4588 consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, boolean renderInverted, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        int packedLight = this.method_3068(partialTicks);
        int i = renderInverted ? 1 : -1;
        int i2 = renderInverted ? -1 : 1;
        this.renderVertex(consumer, rotation, x, y, z, i, -1.0f, quadWidthSize, quadHeightSize, u1, v1, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i, 1.0f, quadWidthSize, quadHeightSize, u1, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, 1.0f, quadWidthSize, quadHeightSize, u0, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, -1.0f, quadWidthSize, quadHeightSize, u0, v1, packedLight, red, green, blue, alpha);
    }

    protected void renderVertex(class_4588 buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadWidthSize, float quadHeightSize, float u, float v, int packedLight, float red, float green, float blue, float alpha) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)rotation).mul(quadWidthSize, quadHeightSize, quadWidthSize).add(x, y, z);
        buffer.method_22912((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).method_22913(u, v).method_22915(red, green, blue, alpha).method_22916(packedLight).method_1344();
    }

    public record LavaProvider(class_4002 sprites) implements class_707<SplashParticleOptions>
    {
        public class_703 createParticle(SplashParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashParticle(level, x, y, z, false, true, (class_6862<class_3611>)class_3486.field_15518, this.sprites, null, (class_4002)ModSpriteSets.LAVA_SPLASH_BOTTOM, options);
        }
    }

    public record Provider(class_4002 sprites) implements class_707<SplashParticleOptions>
    {
        public class_703 createParticle(SplashParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashParticle particle = new SplashParticle(level, x, y, z, true, false, (class_6862<class_3611>)class_3486.field_15517, this.sprites, (class_4002)ModSpriteSets.WATER_SPLASH_OVERLAY, (class_4002)ModSpriteSets.WATER_SPLASH_BOTTOM, options);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.method_3084(red, green, blue);
            return particle;
        }
    }
}

