/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle.emitter;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3998;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

public class SplashEmitter
extends class_3998 {
    @Nullable
    private final class_1297 entity;
    private final float velocity;
    private final float absVelocity;
    private final boolean isLava;
    private final class_6862<class_3611> fluidTag;
    private final float widthModifier;
    private final float heightModifier;
    private final float xScale;
    private final float yScale;
    private final class_2396<SplashParticleOptions> splashParticle;
    private final class_2396<FloatParticleOptions> splashRippleParticle;
    private final class_2396<SplashDropletParticleOptions> dropletParticle;
    private final class_2338.class_2339 pos;
    private boolean firstSplash = true;
    private boolean secondSplash = true;

    protected SplashEmitter(class_638 level, double x, double y, double z, class_6862<class_3611> fluidTag, class_2396<SplashParticleOptions> splashParticle, class_2396<FloatParticleOptions> splashRippleParticle, class_2396<SplashDropletParticleOptions> dropletParticle, boolean isLava, SplashEmitterParticleOptions options) {
        super(level, x, y, z);
        this.fluidTag = fluidTag;
        this.splashRippleParticle = splashRippleParticle;
        this.isLava = isLava;
        this.splashParticle = splashParticle;
        this.dropletParticle = dropletParticle;
        this.field_3847 = 8;
        this.pos = class_2338.method_49637((double)x, (double)y, (double)z).method_25503();
        this.velocity = options.velocity();
        this.absVelocity = class_3532.method_15379((float)this.velocity);
        this.widthModifier = options.widthModifier();
        this.heightModifier = options.heightModifier();
        this.xScale = this.widthModifier + 0.5f;
        this.yScale = this.absVelocity * this.heightModifier * this.widthModifier * 2.0f;
        if (options.entityId() > -1) {
            this.entity = level.method_8469(options.entityId());
            return;
        }
        this.entity = null;
    }

    public static SplashEmitterParticleOptions createForEntity(class_1297 entity, class_2396<SplashEmitterParticleOptions> splashParticle, double yVelocity) {
        float entityWidth = entity.method_17681();
        float entityHeight = entity.method_17682();
        class_1297 passenger = entity.method_31483();
        if (passenger != null) {
            entityWidth = Math.max(entityWidth, passenger.method_17681());
            entityHeight += passenger.method_17682() / 2.0f;
        }
        return new SplashEmitterParticleOptions(splashParticle, entityWidth, entityHeight, (float)yVelocity, entity.method_5628());
    }

    public void method_3070() {
        boolean isInFluid;
        if (this.field_3843) {
            return;
        }
        super.method_3070();
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        boolean bl = isInFluid = this.field_3851.method_8316((class_2338)this.pos).method_15767(this.fluidTag) || Util.getCauldronFluid(this.field_3851.method_8320((class_2338)this.pos)).method_15791(this.fluidTag);
        if (!isInFluid || this.field_3845) {
            this.method_3085();
            return;
        }
        if (this.firstSplash) {
            this.spawnSplashParticles(this.xScale, this.yScale, this.yScale * 0.5f / this.widthModifier * 0.3f, this.xScale);
            this.firstSplash = false;
            if (ModConfigs.ENTITIES.splashes.splashBubbles && this.entity != null && this.field_3851.method_8316(this.pos.method_10074()).method_15767(class_3486.field_15517)) {
                int i = 0;
                while ((float)i < 8.0f * (this.widthModifier * 5.0f)) {
                    int xSign = MathUtil.nextSign(this.field_3840);
                    int zSign = MathUtil.nextSign(this.field_3840);
                    this.field_3851.method_8406((class_2394)class_2398.field_11238, this.field_3874 + MathUtil.nextDouble(this.field_3840, 0.1) * (double)xSign, this.field_3840.method_43048(3) == 0 ? class_3532.method_15366((class_5819)this.field_3840, (double)(this.entity.method_23318() + (double)this.heightModifier), (double)this.field_3854) : this.entity.method_23319(), this.field_3871 + MathUtil.nextDouble(this.field_3840, 0.1) * (double)zSign, MathUtil.nextNonAbsDouble(this.field_3840, this.xScale), (double)(-this.absVelocity * 2.0f) * class_3532.method_15366((class_5819)this.field_3840, (double)0.5, (double)2.0), MathUtil.nextNonAbsDouble(this.field_3840, this.xScale));
                    ++i;
                }
            }
            if (!ModConfigs.ENTITIES.splashes.secondarySplash || this.velocity > -((Float)ModConfigs.ENTITIES.splashes.secondarySplashVelocityThreshold.get()).floatValue()) {
                this.method_3085();
            }
            return;
        }
        if (this.field_3866 >= this.field_3847 && this.secondSplash) {
            this.spawnSplashParticles(this.xScale / 2.0f, this.yScale * 1.5f, this.yScale * 0.85f / this.widthModifier * 0.3f, this.xScale * 0.8f);
            this.secondSplash = false;
        }
    }

    private void spawnSplashParticles(float xScale, float yScale, float dropletYSpeed, float dropletXSpeed) {
        this.field_3851.method_17452((class_2394)new SplashParticleOptions(this.splashParticle, xScale, yScale), true, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
        if (this.hasRipple()) {
            this.field_3851.method_17452((class_2394)new FloatParticleOptions(this.splashRippleParticle, xScale), true, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
        }
        if (!ModConfigs.ENTITIES.splashes.splashDroplets) {
            return;
        }
        SplashDropletParticleOptions dropletOptions = new SplashDropletParticleOptions(this.dropletParticle, Math.min(this.xScale, 2.0f), this.isLava ? 1.0f : ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue());
        int i = 0;
        while ((float)i < 4.0f * this.widthModifier) {
            this.field_3851.method_8406((class_2394)dropletOptions, this.field_3874 + MathUtil.nextNonAbsDouble(this.field_3840, xScale), this.field_3854 + MathUtil.nextDouble(this.field_3840, 0.6) * (double)yScale, this.field_3871 + MathUtil.nextNonAbsDouble(this.field_3840, xScale), 0.0, (double)dropletYSpeed, 0.0);
            ++i;
        }
        i = 0;
        while ((float)i < 8.0f * this.widthModifier) {
            int xSign = MathUtil.nextSign(this.field_3840);
            int zSign = MathUtil.nextSign(this.field_3840);
            this.field_3851.method_8406((class_2394)dropletOptions, this.field_3874 + MathUtil.nextDouble(this.field_3840, xScale) * (double)xSign, this.field_3854 + MathUtil.nextDouble(this.field_3840, 0.6) * (double)yScale, this.field_3871 + MathUtil.nextDouble(this.field_3840, xScale) * (double)zSign, class_3532.method_15366((class_5819)this.field_3840, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)xSign, (double)dropletYSpeed, class_3532.method_15366((class_5819)this.field_3840, (double)0.01, (double)0.1) * (double)dropletXSpeed * (double)zSign);
            ++i;
        }
    }

    private boolean hasRipple() {
        if (ModConfigs.ENTITIES.splashes.splashRipples) {
            if (!ModConfigs.ENTITIES.splashes.lavaSplashRipples && this.isLava) {
                return false;
            }
            return this.firstSplash || this.secondSplash && ModConfigs.ENTITIES.splashes.secondarySplashRipples;
        }
        return false;
    }

    public record LavaProvider() implements class_707<SplashEmitterParticleOptions>
    {
        public class_703 createParticle(SplashEmitterParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashEmitter(level, x, y, z, (class_6862<class_3611>)class_3486.field_15518, ModParticles.LAVA_SPLASH.get(), ModParticles.LAVA_SPLASH_RIPPLE.get(), ModParticles.LAVA_SPLASH_DROPLET.get(), true, options);
        }
    }

    public record Provider() implements class_707<SplashEmitterParticleOptions>
    {
        public class_703 createParticle(SplashEmitterParticleOptions options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashEmitter(level, x, y, z, (class_6862<class_3611>)class_3486.field_15517, ModParticles.WATER_SPLASH.get(), ModParticles.WATER_SPLASH_RIPPLE.get(), ModParticles.WATER_SPLASH_DROPLET.get(), false, options);
        }
    }
}

