/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.ticking.tickers;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.ticking.tickers.BlockPosTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.ChestAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2258;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4739;
import net.minecraft.class_5560;
import net.minecraft.class_5819;

public class ChestBlockEntityTicker
extends BlockPosTicker {
    private static final int MAX_TICKS_SINCE_LAST_ANIMATION = 100;
    private static final Map<class_2338, ChestBlockEntityTicker> CHEST_TICKERS = new HashMap<class_2338, ChestBlockEntityTicker>();
    private int ticksSinceLastAnimation;
    private int animationTicks;
    private float oldOpenness;
    private final class_5560 lidController;

    public ChestBlockEntityTicker(class_1937 level, class_2338 pos, class_5560 lidController) {
        super(level, pos);
        this.lidController = lidController;
    }

    public static void trySpawn(class_1937 level, class_2338 pos) {
        if (!ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && !ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            return;
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity == null || CHEST_TICKERS.containsKey(pos)) {
            return;
        }
        if (blockEntity instanceof ChestAccessor) {
            ChestAccessor chestAccessor = (ChestAccessor)blockEntity;
            ChestBlockEntityTicker ticker = new ChestBlockEntityTicker(level, pos, chestAccessor.subtleEffects$getLidController());
            CHEST_TICKERS.put(pos, ticker);
            TickerManager.add(ticker);
        }
    }

    public static void clear() {
        CHEST_TICKERS.values().forEach(ticker -> ticker.lidController.method_31674(false));
        CHEST_TICKERS.clear();
    }

    @Override
    protected void positionedTick() {
        class_2745 type;
        class_2680 state = this.level.method_8320(this.pos);
        if (!(state.method_26204() instanceof class_4739)) {
            this.remove();
            return;
        }
        class_2586 blockEntity = this.level.method_8321(this.pos);
        if (!(blockEntity instanceof class_2595)) {
            return;
        }
        class_2745 class_27452 = type = state.method_28498((class_2769)class_2281.field_10770) ? (class_2745)state.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        if (type == class_2745.field_12574) {
            return;
        }
        boolean isDoubleChest = type != class_2745.field_12569;
        class_2350 connectedDirection = isDoubleChest ? class_2281.method_9758((class_2680)state) : class_2350.field_11043;
        class_2338 oppositePos = this.pos.method_10093(connectedDirection);
        if (class_2281.method_9756((class_1936)this.level, (class_2338)this.pos) || isDoubleChest && class_2281.method_9756((class_1936)this.level, (class_2338)oppositePos)) {
            this.animationTicks = 0;
            this.ticksSinceLastAnimation = 0;
            return;
        }
        if (ModConfigs.BLOCKS.randomChestOpeningNeedsSoulSand && (ChestBlockEntityTicker.isNotUpwardsBubbleColumn(this.level, this.pos) || isDoubleChest && ChestBlockEntityTicker.isNotUpwardsBubbleColumn(this.level, oppositePos))) {
            return;
        }
        if (!ChestBlockEntityTicker.isUnderwater(this.level, this.pos) || isDoubleChest && !ChestBlockEntityTicker.isUnderwater(this.level, oppositePos)) {
            return;
        }
        class_5819 random = this.level.method_8409();
        float openness = this.lidController.method_31673(Util.getPartialTicks());
        if (openness > 0.0f && ModConfigs.BLOCKS.openingChestsSpawnsBubbles) {
            boolean isClosing;
            boolean bl = isClosing = (double)openness <= 0.5 && openness < this.oldOpenness;
            if (isClosing || random.method_43048(isDoubleChest ? 2 : 4) == 0) {
                double xOffset = 0.0;
                double zOffset = 0.0;
                double xRandomOffset = 0.3125;
                double zRandomOffset = 0.3125;
                if (isDoubleChest) {
                    xOffset = 0.5 * (double)connectedDirection.method_10148();
                    zOffset = 0.5 * (double)connectedDirection.method_10165();
                    class_2350.class_2351 axis = connectedDirection.method_10166();
                    if (axis == class_2350.class_2351.field_11048) {
                        xRandomOffset = 0.8125;
                    } else if (axis == class_2350.class_2351.field_11051) {
                        zRandomOffset = 0.8125;
                    }
                }
                double xSpeed = 0.0;
                double zSpeed = 0.0;
                if (isClosing) {
                    class_2350 facing = (class_2350)state.method_11654((class_2769)class_2281.field_10768);
                    xSpeed = 0.5 * (double)facing.method_10148();
                    zSpeed = 0.5 * (double)facing.method_10165();
                }
                this.level.method_8406((class_2394)class_2398.field_11238, (double)this.pos.method_10263() + 0.5 + xOffset + MathUtil.nextNonAbsDouble(random, xRandomOffset), (double)this.pos.method_10264() + 0.625, (double)this.pos.method_10260() + 0.5 + zOffset + MathUtil.nextNonAbsDouble(random, zRandomOffset), xSpeed, 0.0, zSpeed);
            }
        }
        this.oldOpenness = openness;
        if (ChestBlockEntityTicker.isDownwardsBubbleColumn(this.level, this.pos) || isDoubleChest && ChestBlockEntityTicker.isDownwardsBubbleColumn(this.level, oppositePos)) {
            return;
        }
        if (this.ticksSinceLastAnimation < 100) {
            ++this.ticksSinceLastAnimation;
            return;
        }
        boolean isEnderChest = state.method_27852(class_2246.field_10443);
        if (ModConfigs.BLOCKS.chestsOpenRandomlyUnderwater && random.method_43048(100) == 0 && openness == 0.0f) {
            blockEntity.method_11004(1, 1);
            this.playSound(connectedDirection, type, isEnderChest ? class_3417.field_14952 : class_3417.field_14982);
            this.animationTicks = class_3532.method_15395((class_5819)random, (int)50, (int)200);
            return;
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
            if (this.animationTicks <= 0) {
                blockEntity.method_11004(1, 0);
                this.playSound(connectedDirection, type, isEnderChest ? class_3417.field_15206 : class_3417.field_14823);
                this.ticksSinceLastAnimation = 0;
            }
        }
    }

    public static boolean isNotUpwardsBubbleColumn(class_1937 level, class_2338 pos) {
        class_2680 belowState = level.method_8320(pos.method_10074());
        return !belowState.method_27852(class_2246.field_10114) && (!belowState.method_27852(class_2246.field_10422) || (Boolean)belowState.method_11654((class_2769)class_2258.field_10680) != false);
    }

    public static boolean isDownwardsBubbleColumn(class_1937 level, class_2338 pos) {
        class_2680 belowState = level.method_8320(pos.method_10074());
        return belowState.method_27852(class_2246.field_10092) || belowState.method_27852(class_2246.field_10422) && (Boolean)belowState.method_11654((class_2769)class_2258.field_10680) != false;
    }

    @Override
    public void remove() {
        super.remove();
        CHEST_TICKERS.remove(this.pos);
    }

    public static boolean isUnderwater(class_1937 level, class_2338 pos) {
        return level.method_22351(pos) && level.method_8320(pos.method_10084()).method_27852(class_2246.field_10382);
    }

    private void playSound(class_2350 direction, class_2745 type, class_3414 sound) {
        double x = (float)this.pos.method_10263() + 0.5f;
        double y = (float)this.pos.method_10264() + 0.5f;
        double z = (float)this.pos.method_10260() + 0.5f;
        if (type == class_2745.field_12571) {
            x += (double)((float)direction.method_10148() * 0.5f);
            z += (double)((float)direction.method_10165() * 0.5f);
        }
        this.level.method_43128((class_1657)class_310.method_1551().field_1724, x, y, z, sound, class_3419.field_15245, 0.5f, this.level.method_8409().method_43057() * 0.1f + 0.9f);
    }
}

