/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.client.model.particle.SplashParticleModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.compat.CompatHelper;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModBlockTickers;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModEntityTickers;
import einstein.subtle_effects.init.ModParticleGroups;
import einstein.subtle_effects.init.ModParticleLayers;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModPayloads;
import einstein.subtle_effects.init.ModPipelines;
import einstein.subtle_effects.init.ModRenderTypes;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.ticking.GeyserManager;
import einstein.subtle_effects.ticking.biome_particles.BiomeParticleManager;
import einstein.subtle_effects.ticking.tickers.ChestBlockEntityTicker;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.ticking.tickers.WaterfallTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.util.Util;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SubtleEffectsClient {
    private static boolean HAS_CLEARED = false;
    private static boolean DISPLAY_PARTICLE_COUNT = false;
    private static boolean HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = false;
    public static boolean DISPLAY_PARTICLE_BOUNDING_BOXES = false;
    private static Level LEVEL;

    public static void clientSetup() {
        ModConfigs.init();
        ModPipelines.init();
        ModRenderTypes.init();
        ModParticleLayers.init();
        ModPayloads.initClientHandlers();
        ModEntityTickers.init();
        ModBlockTickers.init();
        BiomeParticleManager.init();
        ModDamageListeners.init();
        ModParticleGroups.init();
        ModParticles.init();
        ModSpriteSets.init();
        ModAnimalFedEffectSettings.init();
        CompatHelper.init();
    }

    public static void clientTick(Minecraft minecraft, Level level) {
        LocalPlayer player = minecraft.player;
        if (level == null || player == null || LEVEL != level) {
            LEVEL = level;
            if (!HAS_CLEARED) {
                SubtleEffectsClient.clear(level);
                BiomeParticleManager.clear();
                HAS_CLEARED = true;
            }
            return;
        }
        if (minecraft.isPaused() || level.tickRateManager().isFrozen()) {
            return;
        }
        if (!HAS_DISPLAYED_BIRTHDAY_NOTIFICATION && ModConfigs.GENERAL.enableEasterEggs && PartyHatLayer.isModBirthday(true)) {
            long years = ChronoUnit.YEARS.between(LocalDate.of(2024, Month.OCTOBER, 3), LocalDate.now());
            SubtleEffectsClient.sendSystemMsg(minecraft, (Component)Component.empty().append((Component)Component.translatable((String)"chat.subtle_effects.prefix").withStyle(style -> style.withColor(ChatFormatting.BLUE))).append(CommonComponents.SPACE).append((Component)Component.translatable((String)"chat.subtle_effects.anniversary.message", (Object[])new Object[]{Util.getOrdinal(years)})));
            HAS_DISPLAYED_BIRTHDAY_NOTIFICATION = true;
        }
        if (DISPLAY_PARTICLE_COUNT) {
            player.displayClientMessage((Component)Component.translatable((String)"ui.subtle_effects.hud.particle_count", (Object[])new Object[]{minecraft.particleEngine.countParticles()}), true);
        }
        ProfilerFiller profiler = Profiler.get();
        profiler.push("subtle_effects");
        profiler.push("biome_particles");
        BiomeParticleManager.tickBiomeParticles(level, (Player)player);
        profiler.pop();
        profiler.push("tickers");
        TickerManager.tick();
        profiler.pop();
        HAS_CLEARED = false;
        profiler.pop();
    }

    public static Map<ModelLayerLocation, Supplier<LayerDefinition>> registerModelLayers() {
        HashMap<ModelLayerLocation, Supplier<LayerDefinition>> layers = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        layers.put(EinsteinSolarSystemModel.MODEL_LAYER, EinsteinSolarSystemModel::createLayer);
        layers.put(PartyHatModel.MODEL_LAYER, PartyHatModel::createLayer);
        layers.put(SplashParticleModel.MODEL_LAYER, SplashParticleModel::createLayer);
        return layers;
    }

    public static <T extends Avatar> List<RenderLayer<AvatarRenderState, PlayerModel>> registerPlayerRenderLayers(AvatarRenderer<T> renderer, EntityRendererProvider.Context context) {
        ArrayList<RenderLayer<AvatarRenderState, PlayerModel>> renderLayers = new ArrayList<RenderLayer<AvatarRenderState, PlayerModel>>();
        renderLayers.add(new EinsteinSolarSystemLayer(renderer, context));
        if (PartyHatLayer.isModBirthday(false)) {
            renderLayers.add(new PartyHatLayer(renderer, context));
        }
        return renderLayers;
    }

    public static <T extends SharedSuggestionProvider> void registerClientCommands(CommandDispatcher<T> dispatcher, CommandBuildContext buildContext) {
        Minecraft minecraft = Minecraft.getInstance();
        LiteralArgumentBuilder particlesClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            minecraft.particleEngine.clearParticles();
            SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.clear.success"));
            return 1;
        });
        RequiredArgumentBuilder particlesCountEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> SubtleEffectsClient.toggleParticleCount(minecraft, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")));
        LiteralArgumentBuilder particlesCount = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"count").executes(context -> SubtleEffectsClient.toggleParticleCount(minecraft, true))).then((ArgumentBuilder)particlesCountEnabled);
        RequiredArgumentBuilder particlesBoundingBoxesEnabled = (RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> SubtleEffectsClient.toggleParticleBoundingBoxes(minecraft, BoolArgumentType.getBool((CommandContext)context, (String)"enabled")));
        LiteralArgumentBuilder particlesBoundingBoxes = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"display_bounding_boxes").executes(context -> SubtleEffectsClient.toggleParticleBoundingBoxes(minecraft, true))).then((ArgumentBuilder)particlesBoundingBoxesEnabled);
        LiteralArgumentBuilder particles = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"particles").then((ArgumentBuilder)particlesClear)).then((ArgumentBuilder)particlesCount)).then((ArgumentBuilder)particlesBoundingBoxes);
        LiteralArgumentBuilder tickersClear = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"clear").executes(context -> {
            SubtleEffectsClient.clear((Level)minecraft.level);
            SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.tickers.clear.success"));
            return 1;
        });
        LiteralArgumentBuilder tickers = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"tickers").then((ArgumentBuilder)tickersClear);
        LiteralArgumentBuilder subtleEffects = (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"subtle_effects").then((ArgumentBuilder)particles)).then((ArgumentBuilder)tickers);
        LiteralCommandNode subtleEffectsNode = dispatcher.register(subtleEffects);
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"se").redirect((CommandNode)subtleEffectsNode));
    }

    private static int toggleParticleCount(Minecraft minecraft, boolean enabled) {
        DISPLAY_PARTICLE_COUNT = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.count." + enabledString + ".success"));
        return 1;
    }

    private static int toggleParticleBoundingBoxes(Minecraft minecraft, boolean enabled) {
        DISPLAY_PARTICLE_BOUNDING_BOXES = enabled;
        String enabledString = enabled ? "enable" : "disable";
        SubtleEffectsClient.sendSystemMsg(minecraft, (Component)SubtleEffectsClient.getMsgTranslation("subtle_effects.particles.display_bounding_boxes." + enabledString + ".success"));
        return 1;
    }

    private static MutableComponent getMsgTranslation(String string) {
        return Component.translatable((String)("commands.subtle_effects." + string));
    }

    private static void sendSystemMsg(Minecraft minecraft, Component component) {
        minecraft.gui.getChat().addMessage(component);
    }

    public static void clear(@Nullable Level level) {
        TickerManager.clear();
        EntityTickerManager.clear(level);
        GeyserManager.ACTIVE_GEYSERS.clear();
        GeyserManager.INACTIVE_GEYSERS.clear();
        WaterfallTicker.WATERFALLS.clear();
        ChestBlockEntityTicker.clear();
    }
}

