/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects;

import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.client.renderer.ParticleBoundingBoxesRenderer;
import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.data.MobSkullShaderReloadListener;
import einstein.subtle_effects.data.NamedReloadListener;
import einstein.subtle_effects.data.SparkProviderReloadListener;
import einstein.subtle_effects.platform.NeoForgeRegistryHelper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleGroupsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="subtle_effects", dist={Dist.CLIENT})
public class SubtleEffectsNeoForgeClient {
    public SubtleEffectsNeoForgeClient(IEventBus modEventBus) {
        SubtleEffectsClient.clientSetup();
        modEventBus.addListener(event -> NeoForgeRegistryHelper.PARTICLE_PROVIDERS.forEach((particle, provider) -> SubtleEffectsNeoForgeClient.registerParticle(event, particle, provider)));
        modEventBus.addListener(event -> NeoForgeRegistryHelper.PARTICLE_GROUP_FACTORIES.forEach((arg_0, arg_1) -> ((RegisterParticleGroupsEvent)event).register(arg_0, arg_1)));
        modEventBus.addListener(event -> event.addPackFinders(BCWPPackManager.PACK_LOCATION.get(), PackType.CLIENT_RESOURCES, BCWPPackManager.PACK_NAME, PackSource.BUILT_IN, false, Pack.Position.TOP));
        modEventBus.addListener(event -> {
            SubtleEffectsNeoForgeClient.addReloadListener(event, new SparkProviderReloadListener());
            SubtleEffectsNeoForgeClient.addReloadListener(event, new MobSkullShaderReloadListener());
            SubtleEffectsNeoForgeClient.addReloadListener(event, new BCWPPackManager());
        });
        modEventBus.addListener(event -> SubtleEffectsClient.registerModelLayers().forEach((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1)));
        modEventBus.addListener(event -> {
            for (PlayerModelType model : event.getSkins()) {
                AvatarRenderer renderer = event.getPlayerRenderer(model);
                if (renderer == null || !(renderer instanceof AvatarRenderer)) continue;
                AvatarRenderer avatarRenderer = renderer;
                SubtleEffectsClient.registerPlayerRenderLayers(avatarRenderer, event.getContext()).forEach(arg_0 -> ((AvatarRenderer)avatarRenderer).addLayer(arg_0));
            }
        });
        NeoForge.EVENT_BUS.addListener(event -> {
            Minecraft minecraft = Minecraft.getInstance();
            SubtleEffectsClient.clientTick(minecraft, (Level)minecraft.level);
        });
        NeoForge.EVENT_BUS.addListener(event -> SubtleEffectsClient.registerClientCommands(event.getDispatcher(), event.getBuildContext()));
        NeoForge.EVENT_BUS.addListener(event -> ParticleBoundingBoxesRenderer.extractParticleBoundingBoxes(event.getRenderState(), event.getCamera(), event.getFrustum()));
        NeoForge.EVENT_BUS.addListener(event -> ParticleBoundingBoxesRenderer.renderParticleBoundingBoxes(event.getPoseStack(), event.getLevelRenderState()));
    }

    private static <T extends PreparableReloadListener & NamedReloadListener> void addReloadListener(AddClientReloadListenersEvent event, T listener) {
        event.addListener(((NamedReloadListener)listener).getId(), listener);
    }

    private static <T extends ParticleType<V>, V extends ParticleOptions> void registerParticle(RegisterParticleProvidersEvent event, Supplier<? extends ParticleType<?>> particle, Function<SpriteSet, ? extends ParticleProvider<?>> provider) {
        Supplier<ParticleType<?>> t = particle;
        Function<SpriteSet, ? extends ParticleProvider<?>> v = provider;
        event.registerSpriteSet(t.get(), sprites -> (ParticleProvider)v.apply(sprites));
    }
}

