/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.SubtleEffectsClient;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.mixin.client.particle.ParticleEngineAccessor;
import einstein.subtle_effects.util.ParticleAccessor;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.SingleQuadParticleAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ParticleBoundingBoxesRenderer {
    private static final Map<SingleQuadParticle.Layer, Vector3f> LAYER_TO_COLOR = (Map)Util.make(new HashMap(), map -> {
        map.put(SingleQuadParticle.Layer.TERRAIN, ParticleBoundingBoxesRenderer.stringToColor("TERRAIN"));
        map.put(SingleQuadParticle.Layer.OPAQUE, ParticleBoundingBoxesRenderer.stringToColor("OPAQUE"));
        map.put(SingleQuadParticle.Layer.TRANSLUCENT, ParticleBoundingBoxesRenderer.stringToColor("TRANSLUCENT"));
    });

    private static Vector3f stringToColor(String color) {
        return Vec3.fromRGB24((int)ARGB.color((int)255, (int)color.hashCode())).toVector3f();
    }

    public static void extractParticleBoundingBoxes(LevelRenderState levelRenderState, Camera camera, Frustum frustum) {
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES) {
            Vec3 cameraPos = camera.getPosition();
            Minecraft minecraft = Minecraft.getInstance();
            ArrayList renderStates = new ArrayList();
            float partialTicks = einstein.subtle_effects.util.Util.getPartialTicks();
            Frustum particleFrustum = frustum.offset(-3.0f);
            ((ParticleEngineAccessor)minecraft.particleEngine).getParticles().forEach((renderType, particleGroup) -> {
                if (particleGroup == null || particleGroup.isEmpty()) {
                    return;
                }
                Vector3f renderTypeColor = ParticleBoundingBoxesRenderer.stringToColor(renderType.name());
                particleGroup.getAll().forEach(particle -> {
                    AABB aabb = particle.getBoundingBox();
                    if (particleFrustum.isVisible(aabb)) {
                        SingleQuadParticleAccessor quadAccessor;
                        Vector3f layerColor;
                        ParticleAccessor accessor = (ParticleAccessor)particle;
                        double x = Mth.lerp((double)partialTicks, (double)accessor.getOldX(), (double)accessor.getX()) - cameraPos.x();
                        double y = Mth.lerp((double)partialTicks, (double)accessor.getOldY(), (double)accessor.getY()) - cameraPos.y();
                        double z = Mth.lerp((double)partialTicks, (double)accessor.getOldZ(), (double)accessor.getZ()) - cameraPos.z();
                        Vector3f color = renderTypeColor;
                        if (particle instanceof SingleQuadParticleAccessor && (layerColor = LAYER_TO_COLOR.get((quadAccessor = (SingleQuadParticleAccessor)particle).subtleEffects$getLayer())) != null) {
                            color = layerColor;
                        }
                        aabb = aabb.move(-accessor.getX(), -accessor.getY(), -accessor.getZ());
                        AABB renderTypeAABB = new AABB(aabb.minX, aabb.maxY - 0.02, aabb.minZ, aabb.maxX, aabb.maxY + 0.02, aabb.maxZ);
                        renderStates.add(new ParticleBoundingBoxRenderState(x, y, z, color, aabb, renderTypeAABB));
                    }
                });
            });
            if (!renderStates.isEmpty()) {
                ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$set(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES, renderStates);
            }
        }
    }

    public static void renderParticleBoundingBoxes(PoseStack poseStack, LevelRenderState levelRenderState) {
        List<ParticleBoundingBoxRenderState> renderStates;
        if (SubtleEffectsClient.DISPLAY_PARTICLE_BOUNDING_BOXES && (renderStates = ((RenderStateAttachmentAccessor)levelRenderState).subtleEffects$get(ModRenderStateAttachmentKeys.PARTICLE_BOUNDING_BOXES)) != null) {
            VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
            renderStates.forEach(renderState -> {
                poseStack.pushPose();
                poseStack.translate(renderState.x(), renderState.y(), renderState.z());
                PoseStack.Pose lastPose = poseStack.last();
                ShapeRenderer.renderLineBox((PoseStack.Pose)lastPose, (VertexConsumer)consumer, (AABB)renderState.aabb(), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Vector3f color = renderState.color();
                if (color != null) {
                    ShapeRenderer.renderLineBox((PoseStack.Pose)lastPose, (VertexConsumer)consumer, (AABB)renderState.renderTypeAABB(), (float)renderState.color.x(), (float)renderState.color.y(), (float)renderState.color.z(), (float)1.0f);
                }
                poseStack.popPose();
            });
        }
    }

    public record ParticleBoundingBoxRenderState(double x, double y, double z, Vector3f color, AABB aabb, AABB renderTypeAABB) {
    }
}

