/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import einstein.subtle_effects.client.model.entity.EinsteinSolarSystemModel;
import einstein.subtle_effects.client.renderer.entity.EinsteinSolarSystemArmorLayer;
import einstein.subtle_effects.client.renderer.entity.PartyHatLayer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EinsteinSolarSystemLayer<T extends AvatarRenderState, V extends HumanoidModel<T>>
extends RenderLayer<T, V>
implements RenderLayerParent<T, EinsteinSolarSystemModel<T>> {
    private static final Vector3f[] HEAD_ROTATIONS = new Vector3f[]{new Vector3f(27.6f, 61.0f, -9.7f), new Vector3f(2.5f, 8.6f, -13.8f), new Vector3f(-64.7f, 48.2f, -41.9f)};
    private final EinsteinSolarSystemModel<T> model;
    private final CustomHeadLayer<T, EinsteinSolarSystemModel<T>> headLayer;
    private final EinsteinSolarSystemArmorLayer<T, EinsteinSolarSystemModel<T>, HumanoidModel<T>> armorLayer;
    private final PartyHatLayer<T, EinsteinSolarSystemModel<T>> partyHatLayer;

    public EinsteinSolarSystemLayer(RenderLayerParent<T, V> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.model = new EinsteinSolarSystemModel(context.bakeLayer(EinsteinSolarSystemModel.MODEL_LAYER));
        this.headLayer = new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getPlayerSkinRenderCache());
        this.armorLayer = new EinsteinSolarSystemArmorLayer(this, ArmorModelSet.bake((ArmorModelSet)ModelLayers.PLAYER_ARMOR, (EntityModelSet)context.getModelSet(), EinsteinSolarSystemModel::new), context.getEquipmentRenderer());
        if (PartyHatLayer.isModBirthday(false)) {
            this.partyHatLayer = new PartyHatLayer(this, context);
            return;
        }
        this.partyHatLayer = null;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, T renderState, float yRot, float xRot) {
        RenderStateAttachmentAccessor accessor = (RenderStateAttachmentAccessor)renderState;
        if (EinsteinSolarSystemLayer.shouldRender(renderState)) {
            int headCount = HEAD_ROTATIONS.length;
            this.model.hat.visible = ((AvatarRenderState)renderState).showHat;
            for (int i = 0; i < headCount; ++i) {
                float i1 = i + 1;
                float spin = EinsteinSolarSystemLayer.getSpin(accessor, i) * ((float)headCount / i1);
                Vector3f rotation = HEAD_ROTATIONS[i];
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-180.0f - ((AvatarRenderState)renderState).bodyRot));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation(spin));
                poseStack.translate(0.7 * (double)i1, ((AvatarRenderState)renderState).isCrouching ? 0.0 : -0.25, 0.0);
                poseStack.scale(0.8f, 0.8f, 0.8f);
                poseStack.pushPose();
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotation.x()));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation.y()));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotation.z()));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotation(spin));
                RenderType renderType = RenderType.entityCutout((ResourceLocation)((AvatarRenderState)renderState).skin.body().texturePath());
                int packedOverlay = LivingEntityRenderer.getOverlayCoords(renderState, (float)0.0f);
                this.model.setAllVisible(true);
                nodeCollector.submitModel(this.model, renderState, poseStack, renderType, packedLight, packedOverlay, ((AvatarRenderState)renderState).outlineColor, null);
                poseStack.translate(0.0, 0.25, 0.0);
                this.headLayer.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                this.armorLayer.submit(poseStack, nodeCollector, packedLight, (HumanoidRenderState)renderState, yRot, xRot);
                if (this.partyHatLayer != null) {
                    this.partyHatLayer.submit(poseStack, nodeCollector, packedLight, renderState, yRot, xRot);
                }
                poseStack.popPose();
                poseStack.popPose();
            }
        }
    }

    public EinsteinSolarSystemModel<T> getModel() {
        return this.model;
    }

    public static boolean shouldRender(HumanoidRenderState renderState) {
        String uuid = ((RenderStateAttachmentAccessor)renderState).subtleEffects$get(ModRenderStateAttachmentKeys.STRING_UUID);
        if (uuid == null) {
            return false;
        }
        return ModConfigs.GENERAL.enableEasterEggs && (Util.isMincraftEinstein(uuid) || Services.PLATFORM.isDevelopmentEnvironment()) && !renderState.isInvisible;
    }

    public static float getSpin(RenderStateAttachmentAccessor accessor, float speed) {
        return accessor.subtleEffects$get(ModRenderStateAttachmentKeys.SOLAR_SYSTEM_SPIN).floatValue() + (float)Math.PI * speed;
    }
}

