/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import einstein.subtle_effects.SubtleEffects;
import einstein.subtle_effects.client.model.entity.PartyHatModel;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionfc;

public class PartyHatLayer<T extends AvatarRenderState, V extends HumanoidModel<T>>
extends RenderLayer<T, V> {
    public static final List<ResourceLocation> TEXTURES = (List)Util.make(new ArrayList(), textures -> {
        PartyHatLayer.addTexture(textures, "big_fuzz_0");
        PartyHatLayer.addTexture(textures, "big_fuzz_1");
        PartyHatLayer.addTexture(textures, "big_fuzz_2");
        PartyHatLayer.addTexture(textures, "big_fuzz_3");
        PartyHatLayer.addTexture(textures, "big_fuzz_4");
        PartyHatLayer.addTexture(textures, "small_fuzz_0");
        PartyHatLayer.addTexture(textures, "small_fuzz_1");
        PartyHatLayer.addTexture(textures, "small_fuzz_2");
        PartyHatLayer.addTexture(textures, "small_fuzz_3");
        PartyHatLayer.addTexture(textures, "small_fuzz_4");
    });
    private final PartyHatModel model;

    public PartyHatLayer(RenderLayerParent<T, V> renderer, EntityRendererProvider.Context context) {
        super(renderer);
        this.model = new PartyHatModel(context.bakeLayer(PartyHatModel.MODEL_LAYER));
    }

    public static void addTexture(List<ResourceLocation> textures, String name) {
        textures.add(SubtleEffects.loc("textures/entity/party_hat/" + name + ".png"));
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector collector, int packedLight, T renderState, float yRot, float xRot) {
        RenderStateAttachmentAccessor accessor = (RenderStateAttachmentAccessor)renderState;
        if (PartyHatLayer.shouldRender(renderState)) {
            poseStack.pushPose();
            ((HumanoidModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            String uuid = accessor.subtleEffects$get(ModRenderStateAttachmentKeys.STRING_UUID);
            uuid = uuid != null ? uuid : "4";
            float id = (float)Math.sin(uuid.hashCode());
            poseStack.translate(0.0, -0.5, 0.0);
            poseStack.rotateAround((Quaternionfc)Axis.ZP.rotationDegrees(id * 22.5f), 0.0f, 0.25f, 0.0f);
            RenderType renderType = this.model.renderType(PartyHatLayer.getHatTexture(id, uuid));
            collector.submitModel((Model)this.model, renderState, poseStack, renderType, packedLight, OverlayTexture.NO_OVERLAY, ((AvatarRenderState)renderState).outlineColor, null);
            poseStack.popPose();
        }
    }

    private static ResourceLocation getHatTexture(float id, String uuid) {
        if (einstein.subtle_effects.util.Util.isMincraftEinstein(uuid)) {
            return TEXTURES.getFirst();
        }
        int index = (int)(Mth.abs((float)id) * (float)TEXTURES.size());
        return TEXTURES.get(index >= TEXTURES.size() ? TEXTURES.size() - 1 : index);
    }

    public static boolean shouldRender(AvatarRenderState renderState) {
        return ModConfigs.GENERAL.enableEasterEggs && !renderState.isInvisible;
    }

    public static boolean isModBirthday(boolean ignoreInDev) {
        if (!ignoreInDev && Services.PLATFORM.isDevelopmentEnvironment()) {
            return true;
        }
        LocalDate date = LocalDate.now();
        Month month = date.getMonth();
        int dayOfMonth = date.getDayOfMonth();
        return month == Month.OCTOBER && dayOfMonth >= 3 && dayOfMonth <= 5;
    }
}

