/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.util.EntityProvider;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class ModDamageListeners {
    public static final Map<EntityType<?>, EntityProvider<?>> REGISTERED = new HashMap();

    public static void init() {
        ModDamageListeners.register(EntityType.CHICKEN, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedChickenFeathers) {
                ParticleOptions particle = ModDamageListeners.getChickenFeatherParticle(entity);
                for (int i = 0; i < 10; ++i) {
                    level.addParticle(particle, entity.getX(), entity.getY(0.5), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.PARROT, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedParrotFeathers) {
                SimpleParticleType particle = switch (entity.getVariant()) {
                    default -> throw new MatchException(null, null);
                    case Parrot.Variant.BLUE -> ModParticles.BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.GRAY -> ModParticles.GRAY_PARROT_FEATHER.get();
                    case Parrot.Variant.GREEN -> ModParticles.GREEN_PARROT_FEATHER.get();
                    case Parrot.Variant.RED_BLUE -> ModParticles.RED_BLUE_PARROT_FEATHER.get();
                    case Parrot.Variant.YELLOW_BLUE -> ModParticles.YELLOW_BLUE_PARROT_FEATHER.get();
                };
                for (int i = 0; i < 5; ++i) {
                    level.addParticle((ParticleOptions)particle, entity.getX(), entity.getY(0.5), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.SNOW_GOLEM, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSnowGolemSnowflakes) {
                for (int i = 0; i < 20; ++i) {
                    level.addParticle((ParticleOptions)ModParticles.SNOW.get(), entity.getX(), entity.getY((double)random.nextFloat()), entity.getZ(), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random), MathUtil.nextNonAbsDouble(random));
                }
            }
        });
        ModDamageListeners.register(EntityType.SHEEP, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSheepFluff) {
                ParticleSpawnUtil.spawnSheepFluff(entity, random.nextInt(3));
            }
        });
        ModDamageListeners.register(EntityType.SLIME, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.attackedSlimeSlime) {
                boolean replaceSlimeSquishParticles = ModConfigs.ENTITIES.replaceSlimeSquishParticles;
                BlockParticleOption options = replaceSlimeSquishParticles ? new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SLIME_BLOCK.defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, Items.SLIME_BALL.getDefaultInstance());
                double maxSpeed = replaceSlimeSquishParticles ? 0.5 : 0.15;
                for (int i = 0; i < 10 * entity.getSize(); ++i) {
                    int xSign = MathUtil.nextSign(random);
                    int zSign = MathUtil.nextSign(random);
                    level.addParticle((ParticleOptions)options, entity.getX(MathUtil.nextDouble(random, 0.5) * (double)xSign), entity.getRandomY(), entity.getZ(MathUtil.nextDouble(random, 0.5) * (double)zSign), MathUtil.nextDouble(random, maxSpeed) * (double)xSign, 0.0, MathUtil.nextDouble(random, maxSpeed) * (double)zSign);
                }
            }
        });
    }

    private static ParticleOptions getChickenFeatherParticle(Chicken chicken) {
        Holder variant = chicken.getVariant();
        if (variant.is(ChickenVariants.WARM)) {
            return (ParticleOptions)ModParticles.WARM_CHICKEN_FEATHER.get();
        }
        if (variant.is(ChickenVariants.COLD)) {
            return (ParticleOptions)ModParticles.COLD_CHICKEN_FEATHER.get();
        }
        return (ParticleOptions)ModParticles.CHICKEN_FEATHER.get();
    }

    private static <T extends Entity> void register(EntityType<T> type, EntityProvider<T> provider) {
        REGISTERED.put(type, provider);
    }
}

