/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.Util;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public GameRenderer gameRenderer;
    @Shadow
    @Final
    public Options options;

    @Inject(method={"setScreen"}, at={@At(value="TAIL")})
    private void setScreen(Screen screen, CallbackInfo ci) {
        if (screen != null && this.player != null && ModConfigs.GENERAL.mobSkullShaders) {
            this.gameRenderer.clearPostEffect();
            Util.applyHelmetShader(this.player.getItemBySlot(EquipmentSlot.HEAD), this.options.getCameraType());
        }
    }
}

