/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.block;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SlimeBlock.class})
public class SlimeBlockMixin {
    @Inject(method={"fallOn"}, at={@At(value="HEAD")})
    private void bounceUp(Level level, BlockState state, BlockPos pos, Entity entity, double distance, CallbackInfo ci) {
        if (entity.level().isClientSide() && ModConfigs.BLOCKS.slimeBlockBounceSounds && distance > 1.0) {
            if (distance < 4.0) {
                Util.playClientSound(entity, SoundEvents.SLIME_SQUISH_SMALL, entity.getSoundSource(), 0.5f, 1.0f);
                return;
            }
            Util.playClientSound(entity, SoundEvents.SLIME_SQUISH, entity.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

