/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModDamageListeners;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.entity.EntityTicker;
import einstein.subtle_effects.util.EntityTickerAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class ClientEntityMixin
implements EntityTickerAccessor {
    @Unique
    private final Entity subtleEffects$me = (Entity)this;
    @Unique
    private final Int2ObjectMap<EntityTicker<?>> subtleEffects$tickers = new Int2ObjectOpenHashMap();
    @Unique
    private double subtleEffects$nextCobwebSound = 0.5;
    @Unique
    private Vec3 subtleEffects$lastPos = Vec3.ZERO;

    @Shadow
    protected abstract boolean isInvulnerableToBase(DamageSource var1);

    @Inject(method={"playEntityOnFireExtinguishedSound"}, at={@At(value="TAIL")})
    private void addExtinguishParticles(CallbackInfo ci) {
        Level level = this.subtleEffects$me.level();
        if (level.isClientSide() && ModConfigs.ENTITIES.burning.extinguishSteam) {
            AABB boundingBox = this.subtleEffects$me.getBoundingBox();
            RandomSource random = this.subtleEffects$me.getRandom();
            for (int x = Mth.floor((double)boundingBox.minX); x < Mth.ceil((double)boundingBox.maxX); ++x) {
                for (int y = Mth.floor((double)boundingBox.minY); y < Mth.ceil((double)boundingBox.maxY); ++y) {
                    for (int z = Mth.floor((double)boundingBox.minZ); z < Mth.ceil((double)boundingBox.maxZ); ++z) {
                        BlockPos abovePos;
                        BlockPos pos = new BlockPos(x, y, z);
                        BlockState state = level.getBlockState(pos);
                        FluidState fluidState = level.getFluidState(pos);
                        double fluidHeight = Math.max(Util.getCauldronFillHeight(state), (double)fluidState.getHeight((BlockGetter)level, pos));
                        if (!(fluidHeight > 0.0) || !fluidState.is((Fluid)Fluids.WATER) && !state.is(Blocks.WATER_CAULDRON) || Util.isSolidOrNotEmpty(level, abovePos = pos.above())) continue;
                        for (int i = 0; i < 5; ++i) {
                            level.addParticle((ParticleOptions)ModParticles.STEAM.get(), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + fluidHeight + MathUtil.nextDouble(random, 0.5), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"onInsideBlock"}, at={@At(value="HEAD")})
    private void inside(BlockState state, CallbackInfo ci) {
        if (this.subtleEffects$me.level().isClientSide() && ModConfigs.BLOCKS.cobwebMovementSounds && (double)this.subtleEffects$me.flyDist > this.subtleEffects$nextCobwebSound && state.is(Blocks.COBWEB) && this.subtleEffects$lastPos.distanceToSqr(this.subtleEffects$me.position()) > 0.5) {
            this.subtleEffects$nextCobwebSound += 0.5;
            this.subtleEffects$lastPos = this.subtleEffects$me.position();
            SoundType soundType = state.getSoundType();
            Util.playClientSound(this.subtleEffects$me, soundType.getStepSound(), this.subtleEffects$me.getSoundSource(), soundType.getVolume() * 0.15f, soundType.getPitch());
        }
    }

    @Inject(method={"hurtOrSimulate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurtClient(Lnet/minecraft/world/damagesource/DamageSource;)Z")})
    public <T extends Entity> void hurtClient(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = this.subtleEffects$me;
        if (entity instanceof LivingEntity) {
            EntityType type;
            LivingEntity entity2 = (LivingEntity)entity;
            if (!this.isInvulnerableToBase(source) && source.getEntity() instanceof LivingEntity && entity2.isAlive() && entity2.hurtTime == 0 && ModDamageListeners.REGISTERED.containsKey(type = entity2.getType())) {
                ModDamageListeners.REGISTERED.get(type).apply((Entity)this, entity2.level(), entity2.getRandom());
            }
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;floor(D)I")}, cancellable=true)
    private void doClientWaterSplash(CallbackInfo ci) {
        if (ParticleSpawnUtil.spawnSplashEffects(this.subtleEffects$me, this.subtleEffects$me.level(), ModParticles.WATER_SPLASH_EMITTER.get(), (TagKey<Fluid>)FluidTags.WATER)) {
            ci.cancel();
        }
    }

    @Override
    public Int2ObjectMap<EntityTicker<?>> subtleEffects$getTickers() {
        return this.subtleEffects$tickers;
    }
}

