/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModRenderStateAttachmentKeys;
import einstein.subtle_effects.util.RenderStateAttachmentAccessor;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity, S extends EntityRenderState> {
    @Inject(method={"extractRenderState"}, at={@At(value="TAIL")})
    private void extractRenderState(T entity, S renderState, float partialTicks, CallbackInfo ci) {
        RenderStateAttachmentAccessor accessor = (RenderStateAttachmentAccessor)renderState;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            accessor.subtleEffects$set(ModRenderStateAttachmentKeys.IS_SLEEPING, livingEntity.isSleeping());
        }
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            accessor.subtleEffects$set(ModRenderStateAttachmentKeys.SOLAR_SYSTEM_SPIN, Float.valueOf(((float)player.tickCount + partialTicks) / 20.0f));
            accessor.subtleEffects$set(ModRenderStateAttachmentKeys.STRING_UUID, player.getStringUUID());
        }
    }

    @ModifyArg(method={"submitNameTag"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitNameTag(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;ILnet/minecraft/network/chat/Component;ZIDLnet/minecraft/client/renderer/state/CameraRenderState;)V"), index=1)
    private Vec3 adjustNameTagOffset(Vec3 nameTagAttachment, @Local(argsOnly=true) EntityRenderState renderState) {
        return Util.getAdjustedNameTagPosition(renderState, nameTagAttachment);
    }
}

