/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.SplashDropletParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Villager.class})
public class VillagerMixin {
    @WrapOperation(method={"handleEntityEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;addParticlesAroundSelf(Lnet/minecraft/core/particles/ParticleOptions;)V")})
    private void replaceSplashParticles(Villager villager, ParticleOptions options, Operation<Void> original) {
        if (ModConfigs.ENTITIES.improvedVillagerSweatingEffects && options.getType() == ParticleTypes.SPLASH) {
            RandomSource random = villager.getRandom();
            Level level = villager.level();
            Vec3 pos = villager.position();
            for (int i = 0; i < 10; ++i) {
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.addParticle((ParticleOptions)new SplashDropletParticleOptions(ModParticles.WATER_SPLASH_DROPLET.get(), 1.0f, 1.0f, true), pos.x() + MathUtil.nextDouble(random, 0.2) * (double)xSign, pos.y() + (double)villager.getEyeHeight() + MathUtil.nextNonAbsDouble(random, 0.3), pos.z() + MathUtil.nextDouble(random, 0.2) * (double)zSign, MathUtil.nextDouble(random, 0.15) * (double)xSign, MathUtil.nextDouble(random, 0.35), MathUtil.nextDouble(random, 0.15) * (double)zSign);
            }
            return;
        }
        original.call(new Object[]{villager, options});
    }
}

