/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.item;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.SparkType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FlintAndSteelItem.class, FireChargeItem.class})
public class FlintAndSteelItemMixin {
    @Inject(method={"useOn"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/gameevent/GameEvent;BLOCK_CHANGE:Lnet/minecraft/core/Holder$Reference;")})
    private void useOn(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level level = context.getLevel();
        if (level.isClientSide()) {
            int i;
            if (!ModConfigs.ITEMS.flintAndSteelParticles) {
                return;
            }
            RandomSource random = level.getRandom();
            Vec3 location = context.getClickLocation();
            for (i = 0; i < 3; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, location.x() + MathUtil.nextNonAbsDouble(random, 0.07), location.y() + MathUtil.nextDouble(random, 0.07), location.z() + MathUtil.nextNonAbsDouble(random, 0.07), 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 10; ++i) {
                level.addParticle((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), location.x() + MathUtil.nextNonAbsDouble(random, 0.07), location.y(), location.z() + MathUtil.nextNonAbsDouble(random, 0.07), 0.0, 0.0, 0.0);
            }
        }
    }
}

