/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.option.FallenLeafParticleOptions;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.FallingLeavesParticle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingLeavesParticle.class})
public abstract class FallingLeavesParticleMixin
extends SingleQuadParticle {
    @Unique
    private final BlockPos.MutableBlockPos subtleEffects$pos = new BlockPos.MutableBlockPos();

    protected FallingLeavesParticleMixin(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
    }

    @ModifyExpressionValue(method={"tick"}, at={@At(value="CONSTANT", args={"doubleValue=0.0024999999441206455"})})
    private double replaceGravity(double original) {
        if (ModConfigs.GENERAL.rainIncreasesLeavesMovementSpeed && Util.isRainingAt((Level)this.level, BlockPos.containing((double)this.x, (double)this.y, (double)this.z))) {
            return original * 1.5;
        }
        return original;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        if (!ModConfigs.GENERAL.leavesLandOnGround && !ModConfigs.GENERAL.leavesLandOnWater) {
            return;
        }
        this.subtleEffects$pos.set(this.x, this.y, this.z);
        BlockState state = this.level.getBlockState((BlockPos)this.subtleEffects$pos);
        FluidState fluidState = this.level.getFluidState((BlockPos)this.subtleEffects$pos);
        boolean isWaterCauldron = state.is(Blocks.WATER_CAULDRON);
        double fluidHeight = ModConfigs.GENERAL.leavesLandOnWater ? (fluidState.is((Fluid)Fluids.WATER) ? (double)fluidState.getHeight((BlockGetter)this.level, (BlockPos)this.subtleEffects$pos) : (isWaterCauldron ? Util.getCauldronFillHeight(state) : 0.0)) : 0.0;
        double surface = (double)this.subtleEffects$pos.getY() + Math.max(fluidHeight, isWaterCauldron ? 0.0 : state.getCollisionShape((BlockGetter)this.level, (BlockPos)this.subtleEffects$pos).max(Direction.Axis.Y)) + 0.01;
        if (fluidHeight > 0.0 && this.y <= surface && ModConfigs.GENERAL.leavesLandOnWater || this.onGround && !state.is(Blocks.WATER) && ModConfigs.GENERAL.leavesLandOnGround) {
            this.level.addParticle((ParticleOptions)new FallenLeafParticleOptions(this.sprite, this.quadSize, this.bbWidth, this.bbHeight, this.onGround, new Vector3f(this.rCol, this.gCol, this.bCol), this.alpha, this.roll), this.x, surface + (double)Mth.nextFloat((RandomSource)this.random, (float)0.001f, (float)0.005f), this.z, this.xd, 0.0, this.zd);
            if (!this.onGround && ModConfigs.GENERAL.leavesLandingOnWaterRipples) {
                double halfSize = this.quadSize / 2.0f;
                this.level.addParticle((ParticleOptions)new FloatParticleOptions(ModParticles.WATER_RIPPLE.get(), Math.max(this.quadSize, Math.max(this.bbWidth, this.bbHeight)) + 0.90000004f), this.x + halfSize, surface, this.z + halfSize, 0.0, 0.0, 0.0);
            }
            this.remove();
        }
    }
}

