/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle.bubbles;

import einstein.subtle_effects.data.BCWPPackManager;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.DrowningBubbleParticle;
import einstein.subtle_effects.platform.Services;
import einstein.subtle_effects.util.BubbleSetter;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BubbleColumnUpParticle;
import net.minecraft.client.particle.BubbleParticle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.WaterCurrentDownParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BubbleParticle.class, BubbleColumnUpParticle.class, WaterCurrentDownParticle.class})
public abstract class BubbleParticleMixin
extends SingleQuadParticle
implements BubbleSetter {
    @Unique
    private TextureAtlasSprite subtleEffects$overlaySprite;
    @Unique
    private boolean subtleEffects$playsSound;
    @Unique
    private int subtleEffects$waterColor;

    protected BubbleParticleMixin(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        this.subtleEffects$waterColor = ((Biome)this.level.getBiome(pos).value()).getWaterColor();
        if (!this.isAlive()) {
            float volume = ((Float)ModConfigs.GENERAL.poppingBubblesVolume.get()).floatValue();
            if (this.subtleEffects$playsSound && volume > 0.0f && !this.level.isWaterAt(pos)) {
                this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.BUBBLE_COLUMN_BUBBLE_POP, SoundSource.AMBIENT, (float)Mth.nextInt((RandomSource)this.random, (int)1, (int)4) * volume, Mth.nextFloat((RandomSource)this.random, (float)1.0f, (float)1.3f), false);
            }
            if (ModConfigs.GENERAL.poppingBubbles) {
                if (this instanceof DrowningBubbleParticle) {
                    this.level.addParticle((ParticleOptions)ModParticles.DROWNING_BUBBLE_POP.get(), this.x, this.y, this.z, this.xd, this.yd, this.zd);
                    return;
                }
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }
    }

    protected void extractRotatedQuad(QuadParticleRenderState state, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        super.extractRotatedQuad(state, quaternion, x, y, z, partialTicks);
        if (this.subtleEffects$overlaySprite != null) {
            float u0 = this.subtleEffects$overlaySprite.getU0();
            float u1 = this.subtleEffects$overlaySprite.getU1();
            float v0 = this.subtleEffects$overlaySprite.getV0();
            float v1 = this.subtleEffects$overlaySprite.getV1();
            state.add(this.getLayer(), x, y, z, quaternion.x, quaternion.y, quaternion.z, quaternion.w, this.getQuadSize(partialTicks), u0, u1, v0, v1, this.subtleEffects$color(), this.getLightColor(partialTicks));
        }
    }

    @Unique
    private int subtleEffects$color() {
        float colorIntensity = 0.2f;
        float whiteIntensity = 1.0f - colorIntensity;
        return ARGB.colorFromFloat((float)(whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 16 & 0xFF) / 255.0f)), (float)(whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor >> 8 & 0xFF) / 255.0f)), (float)(whiteIntensity + colorIntensity * ((float)(this.subtleEffects$waterColor & 0xFF) / 255.0f)), (float)this.alpha);
    }

    @Override
    public void subtleEffects$setupBubble(SpriteSet sprites, boolean playsSound) {
        List<TextureAtlasSprite> textures = Services.PARTICLE_HELPER.getSpritesFromSet(sprites);
        this.subtleEffects$playsSound = playsSound;
        if (textures != null && textures.size() > 1 && BCWPPackManager.isPackLoaded()) {
            this.setSprite(textures.getFirst());
            this.subtleEffects$overlaySprite = textures.get(1);
        }
    }
}

