/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticleLayers;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;

public abstract class BaseWaterfallParticle
extends SingleQuadParticle {
    private final BlockPos.MutableBlockPos pos;
    private final Particle.LifetimeAlpha lifetimeAlpha;

    protected BaseWaterfallParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Particle.LifetimeAlpha lifetimeAlpha, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.lifetimeAlpha = lifetimeAlpha;
        this.alpha = lifetimeAlpha.startAlpha();
        this.pos = BlockPos.containing((double)x, (double)y, (double)z).mutable();
        if (ModConfigs.ENVIRONMENT.waterfalls.randomizeWaterfallParticleRotation) {
            this.oRoll = this.roll = (float)this.random.nextInt();
        }
    }

    public void extract(QuadParticleRenderState state, Camera renderInfo, float partialTicks) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        super.extract(state, renderInfo, partialTicks);
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y, this.z);
        if (this.onGround) {
            this.remove();
            return;
        }
        if (!this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.remove();
        }
    }

    protected SingleQuadParticle.Layer getLayer() {
        return ModParticleLayers.getBlendedOrTransparent();
    }
}

