/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class CommandBlockParticle
extends SingleQuadParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;
    private final Direction direction;

    public CommandBlockParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Direction direction, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.xStart = x;
        this.yStart = y;
        this.zStart = z;
        this.xo = x + xSpeed;
        this.yo = y + ySpeed;
        this.zo = z + zSpeed;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.direction = direction;
        this.quadSize = 0.1f;
        this.hasPhysics = false;
        this.lifetime = 50;
        float shade = Mth.clamp((float)level.random.nextFloat(), (float)0.6f, (float)1.0f);
        this.setColor(shade, shade, shade);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        float $$0 = (float)this.age / (float)this.lifetime;
        $$0 = 1.0f - $$0;
        float $$1 = 1.0f - $$0;
        $$1 *= $$1;
        $$1 *= $$1;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.x = this.xStart + this.xd * (double)$$0 + (double)$$1 * 1.2 * (double)(-this.direction.getStepX());
        this.y = this.yStart + this.yd * (double)$$0 + (double)$$1 * 1.2 * (double)(-this.direction.getStepY());
        this.z = this.zStart + this.zd * (double)$$0 + (double)$$1 * 1.2 * (double)(-this.direction.getStepZ());
    }

    public void move(double x, double y, double z) {
        this.setBoundingBox(this.getBoundingBox().move(x, y, z));
        this.setLocationFromBoundingbox();
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public int getLightColor(float partialTick) {
        return 240;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<DirectionParticleOptions>
    {
        public Particle createParticle(DirectionParticleOptions type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new CommandBlockParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type.direction(), this.sprites.get(random));
        }
    }
}

