/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.particle.option.FloatParticleOptions;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class ExperienceParticle
extends SingleQuadParticle {
    protected ExperienceParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.yd *= (double)0.2f;
        if (xSpeed == 0.0 && zSpeed == 0.0) {
            this.xd *= (double)0.1f;
            this.zd *= (double)0.1f;
        }
        this.quadSize *= 0.3f;
        this.lifetime = (int)(8.0 / (this.random.nextDouble() * 0.8 + 0.2));
        this.hasPhysics = true;
        this.alpha = 0.5f;
        this.gravity = 0.3f;
    }

    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        float f = ((float)this.age + partialTicks) / 2.0f;
        this.rCol = (Mth.sin((float)(f + 0.0f)) + 1.0f) * 0.5f;
        this.gCol = 1.0f;
        this.bCol = (Mth.sin((float)(f + 4.1887903f)) + 1.0f) * 0.1f;
        super.extract(state, camera, partialTicks);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<FloatParticleOptions>
    {
        public Particle createParticle(FloatParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            ExperienceParticle particle = new ExperienceParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites.get(random));
            particle.setPower(options.f());
            return particle;
        }
    }
}

