/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.FallenLeafParticleOptions;
import einstein.subtle_effects.util.MathUtil;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FallenLeafParticle
extends FlatPlaneParticle {
    private final Particle.LifetimeAlpha lifetimeAlpha;

    protected FallenLeafParticle(ClientLevel level, double x, double y, double z, double xSpeed, double zSpeed, FallenLeafParticleOptions options) {
        super(level, x, y, z, Objects.requireNonNull(options.sprite()));
        if (!options.onGround() && ModConfigs.GENERAL.leavesLandingOnWaterKeepMomentum) {
            this.xd = MathUtil.nextDouble(this.random, xSpeed / 4.0 * 3.0);
            this.zd = MathUtil.nextDouble(this.random, zSpeed / 4.0 * 3.0);
        }
        int baseLifetime = (Integer)ModConfigs.GENERAL.fallenLeavesLifeTime.get();
        this.lifetime = baseLifetime + this.random.nextInt(10) * MathUtil.nextSign(this.random);
        this.lifetimeAlpha = new Particle.LifetimeAlpha(options.alpha(), 0.0f, 0.5f, 1.0f);
        this.alpha = this.lifetimeAlpha.startAlpha();
        this.rotation = this.rotation.rotateX(1.5707964f);
        this.friction = 0.96f;
        this.sprite = options.sprite();
        this.oRoll = this.roll = options.rotation();
        this.quadSize = options.quadSize();
        this.setSize(options.bbWidth(), options.bbHeight());
        Vector3f color = options.color();
        this.setColor(color.x, color.y, color.z);
    }

    @Override
    public void extract(QuadParticleRenderState state, Camera renderInfo, float partialTicks) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        super.extract(state, renderInfo, partialTicks);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TRANSLUCENT;
    }

    public record Provider() implements ParticleProvider<FallenLeafParticleOptions>
    {
        @Nullable
        public Particle createParticle(FallenLeafParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return options == FallenLeafParticleOptions.EMPTY ? null : new FallenLeafParticle(level, x, y, z, xSpeed, zSpeed, options);
        }
    }
}

