/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.particle.option.IntegerParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.RandomSource;

public class ItemRarityParticle
extends SingleQuadParticle {
    private final double maxY;

    protected ItemRarityParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int color, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        color = (color >> 24 & 0xFF) != 0 ? color : 0xFF000000 | color;
        this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
        this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
        this.bCol = (float)(color & 0xFF) / 255.0f;
        this.maxY = y + (double)((Float)ModConfigs.ITEMS.itemRarity.particleMaxHeight.get()).floatValue();
        this.gravity = -0.1f;
        this.lifetime = 1;
        this.xd = 0.0;
        this.yd *= (double)((Float)ModConfigs.ITEMS.itemRarity.particleMaxSpeed.get()).floatValue();
        this.zd = 0.0;
    }

    public void tick() {
        super.tick();
        if (this.y == this.yo || this.y >= this.maxY) {
            this.remove();
            return;
        }
        ++this.lifetime;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<IntegerParticleOptions>
    {
        public Particle createParticle(IntegerParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new ItemRarityParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, options.integer(), this.sprites.get(random));
        }
    }
}

