/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import einstein.subtle_effects.init.ModParticleGroups;
import einstein.subtle_effects.particle.group.ModelParticleGroup;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.phys.Vec3;

public abstract class ModelParticle<T extends Model<Unit>>
extends Particle {
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected float rCol = 1.0f;
    protected float gCol = 1.0f;
    protected float bCol = 1.0f;
    protected float alpha = 1.0f;

    protected ModelParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    public ModelParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public ModelParticleGroup.ModelParticleRenderState extractState(Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        poseStack.translate(x, y, z);
        poseStack.scale(1.0f, -1.0f, -1.0f);
        return this.extractState(poseStack, camera, partialTicks);
    }

    public abstract ModelParticleGroup.ModelParticleRenderState extractState(PoseStack var1, Camera var2, float var3);

    protected T bakeModel(Function<ModelPart, T> modelBaker, ModelLayerLocation layerLocation) {
        return (T)((Model)modelBaker.apply(this.minecraft.getEntityModels().bakeLayer(layerLocation)));
    }

    public abstract T getModel();

    protected ResourceLocation getSpriteId(TextureAtlasSprite sprite) {
        return sprite.contents().name().withPrefix("textures/particle/").withSuffix(".png");
    }

    public void setColor(float r, float g, float b) {
        this.rCol = r;
        this.gCol = g;
        this.bCol = b;
    }

    public ParticleRenderType getGroup() {
        return ModParticleGroups.MODEL;
    }
}

