/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import einstein.subtle_effects.init.ModParticleLayers;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.util.MathUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class PotionCloudParticle
extends FlatPlaneParticle {
    private final Particle.LifetimeAlpha lifetimeAlpha = new Particle.LifetimeAlpha(0.5f, 0.0f, 0.5f, 1.0f);

    protected PotionCloudParticle(ClientLevel level, double x, double y, double z, ColorParticleOption option, TextureAtlasSprite sprite) {
        super(level, x, y, z, sprite);
        this.xd = MathUtil.nextNonAbsDouble(this.random, 0.0, 0.03);
        this.zd = MathUtil.nextNonAbsDouble(this.random, 0.0, 0.03);
        this.lifetime = Mth.nextInt((RandomSource)this.random, (int)25, (int)30);
        this.rotation.rotateY((float)(90 * this.random.nextInt(3)) * ((float)Math.PI / 180)).rotateX(-1.5707964f);
        this.alpha = this.lifetimeAlpha.startAlpha();
        this.quadSize = 1.0f;
        this.setSize(2.0f, 0.1f);
        this.setColor(option.getRed(), option.getGreen(), option.getBlue());
    }

    @Override
    public void extract(QuadParticleRenderState state, Camera camera, float partialTicks) {
        this.alpha = this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, partialTicks);
        super.extract(state, camera, partialTicks);
    }

    protected SingleQuadParticle.Layer getLayer() {
        return ModParticleLayers.getBlendedOrTransparent();
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<ColorParticleOption>
    {
        public SingleQuadParticle createParticle(ColorParticleOption option, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new PotionCloudParticle(level, x, y, z, option, this.sprites.get(random));
        }
    }
}

